const saturnTheme = "/* basic theme */\n.light-mode {\n  --scalar-background-1: #f3f3ee;\n  --scalar-background-2: #e8e8e3;\n  --scalar-background-3: #e4e4df;\n  --scalar-border-color: rgba(215, 215, 206, 0.85);\n\n  --scalar-color-1: #2a2f45;\n  --scalar-color-2: #757575;\n  --scalar-color-3: #8e8e8e;\n\n  --scalar-color-accent: #1763a6;\n  --scalar-background-accent: #1f648e1f;\n}\n.dark-mode {\n  --scalar-background-1: #09090b;\n  --scalar-background-2: #18181b;\n  --scalar-background-3: #2c2c30;\n  --scalar-border-color: rgba(255, 255, 255, 0.17);\n\n  --scalar-color-1: #fafafa;\n  --scalar-color-2: rgb(161, 161, 170);\n  --scalar-color-3: rgba(255, 255, 255, 0.533);\n\n  --scalar-color-accent: #4eb3ec;\n  --scalar-background-accent: #8ab4f81f;\n}\n/* Document Sidebar */\n.light-mode .t-doc__sidebar,\n.dark-mode .t-doc__sidebar {\n  --scalar-sidebar-background-1: var(--scalar-background-1);\n  --scalar-sidebar-color-1: var(--scalar-color-1);\n  --scalar-sidebar-color-2: var(--scalar-color-2);\n  --scalar-sidebar-border-color: var(--scalar-border-color);\n\n  --scalar-sidebar-item-hover-background: var(--scalar-background-2);\n  --scalar-sidebar-item-hover-color: currentColor;\n\n  --scalar-sidebar-item-active-background: var(--scalar-background-3);\n  --scalar-sidebar-color-active: var(--scalar-color-1);\n\n  --scalar-sidebar-search-background: var(--scalar-background-1);\n  --scalar-sidebar-search-border-color: var(--scalar-border-color);\n  --scalar-sidebar-search-color: var(--scalar-color-3);\n}\n\n/* advanced */\n.light-mode {\n  --scalar-color-green: #17803d;\n  --scalar-color-red: #e10909;\n  --scalar-color-yellow: #edbe20;\n  --scalar-color-blue: #1763a6;\n  --scalar-color-orange: #e25b09;\n  --scalar-color-purple: #5c3993;\n\n  --scalar-button-1: rgba(0, 0, 0, 1);\n  --scalar-button-1-hover: rgba(0, 0, 0, 0.8);\n  --scalar-button-1-color: rgba(255, 255, 255, 0.9);\n}\n.dark-mode {\n  --scalar-color-green: #30a159;\n  --scalar-color-red: #dc1b19;\n  --scalar-color-yellow: #eec644;\n  --scalar-color-blue: #2b7abf;\n  --scalar-color-orange: #f07528;\n  --scalar-color-purple: #7a59b1;\n\n  --scalar-button-1: rgba(255, 255, 255, 1);\n  --scalar-button-1-hover: rgba(255, 255, 255, 0.9);\n  --scalar-button-1-color: black;\n}\n.dark-mode h2.t-editor__heading,\n.dark-mode .t-editor__page-title h1,\n.dark-mode h1.section-header:not(::selection),\n.dark-mode .markdown h1,\n.dark-mode .markdown h2,\n.dark-mode .markdown h3,\n.dark-mode .markdown h4,\n.dark-mode .markdown h5,\n.dark-mode .markdown h6 {\n  -webkit-text-fill-color: transparent;\n  background-image: linear-gradient(to right bottom, rgb(255, 255, 255) 30%, rgba(255, 255, 255, 0.38));\n  -webkit-background-clip: text;\n  background-clip: text;\n}\n.light-mode *::selection {\n  background-color: color-mix(in srgb, var(--scalar-color-accent), transparent 70%);\n}\n.dark-mode *::selection {\n  background-color: color-mix(in srgb, var(--scalar-color-accent), transparent 50%);\n}\n";
export {
  saturnTheme as default
};
