import defaultFonts from './fonts/fonts.css?inline';
import alternateTheme from './presets/alternate.css?inline';
import bluePlanetTheme from './presets/bluePlanet.css?inline';
import deepSpaceTheme from './presets/deepSpace.css?inline';
import defaultTheme from './presets/default.css?inline';
import elysiajsTheme from './presets/elysiajs.css?inline';
import fastifyTheme from './presets/fastify.css?inline';
import keplerTheme from './presets/kepler.css?inline';
import marsTheme from './presets/mars.css?inline';
import moonTheme from './presets/moon.css?inline';
import laserwaveTheme from './presets/laserwave.css?inline';
import purpleTheme from './presets/purple.css?inline';
import saturnTheme from './presets/saturn.css?inline';
import solarizedTheme from './presets/solarized.css?inline';
export { hasObtrusiveScrollbars } from './utilities/has-obtrusive-scrollbars.js';
export { alternateTheme, bluePlanetTheme, deepSpaceTheme, defaultTheme, elysiajsTheme, fastifyTheme, keplerTheme, marsTheme, moonTheme, purpleTheme, saturnTheme, solarizedTheme, laserwaveTheme, defaultFonts, };
/** Theme definition for Scalar platform themes. Matches user provided theme definitions. */
export type Theme = {
    uid: string;
    /** Display name of the theme */
    name: string;
    /** Description of the theme */
    description: string;
    /** CSS string for the theme */
    theme: string;
    /** Text identifier for the theme. Used for specifying in scalar.config.ts */
    slug: string;
    /** Deprecated themes will still be loadable but will be hidden from the UI for future selection */
    deprecated?: boolean;
};
/** List of available theme IDs as a type. */
export type ThemeId = (typeof themeIds)[number];
export type IntegrationThemeId = 'elysiajs' | 'fastify';
export declare const themeIds: readonly ["alternate", "default", "moon", "purple", "solarized", "bluePlanet", "deepSpace", "saturn", "kepler", "elysiajs", "fastify", "mars", "laserwave", "none"];
/**
 * User readable theme names / labels
 */
export declare const themeLabels: Record<ThemeId, string>;
/**
 * Formatted list of available theme presets.
 *
 * Used across the Scalar platform as base themes. Extendable by team defined themes
 *
 * Static UIDs must be assigned and never changed when a new theme is created.
 * Slugs should be formatted as kebab-case and cannot change after initial creation.
 */
export declare const presets: Record<Exclude<ThemeId, 'none'>, Theme>;
/** List of available theme presets */
export declare const themePresets: Theme[];
/** Starter custom theme styles with all variables and options */
export declare const getStarterTheme: (name: string) => Theme;
/** Get the theme and base variables for a given theme */
export declare const getThemeStyles: (themeId?: ThemeId, opts?: {
    /**
     * Whether or not to include the base variables (e.g. typography)
     *
     * @default true
     */
    variables?: boolean;
    /**
     * Whether or not to include the definitions for the default scalar fonts (e.g. Inter)
     *
     * @default true
     */
    fonts?: boolean;
    /**
     * Cascade layer to assign the theme styles to
     *
     * @default 'scalar-theme'
     */
    layer?: string | false;
}) => string;
//# sourceMappingURL=index.d.ts.map