import defaultFonts from "./fonts/fonts.css2.js";
import alternateTheme from "./presets/alternate.css.js";
import bluePlanetTheme from "./presets/bluePlanet.css.js";
import deepSpaceTheme from "./presets/deepSpace.css.js";
import defaultTheme from "./presets/default.css.js";
import elysiajsTheme from "./presets/elysiajs.css.js";
import fastifyTheme from "./presets/fastify.css.js";
import keplerTheme from "./presets/kepler.css.js";
import marsTheme from "./presets/mars.css.js";
import moonTheme from "./presets/moon.css.js";
import laserwaveTheme from "./presets/laserwave.css.js";
import purpleTheme from "./presets/purple.css.js";
import saturnTheme from "./presets/saturn.css.js";
import solarizedTheme from "./presets/solarized.css.js";
import customThemeStarter from "./presets/custom-theme-starter.css.js";
import { hasObtrusiveScrollbars } from "./utilities/has-obtrusive-scrollbars.js";
import { nanoid } from "nanoid";
const themeIds = [
  "alternate",
  "default",
  "moon",
  "purple",
  "solarized",
  "bluePlanet",
  "deepSpace",
  "saturn",
  "kepler",
  "elysiajs",
  "fastify",
  "mars",
  "laserwave",
  "none"
];
const themeLabels = {
  default: "Default",
  alternate: "Alternate",
  moon: "Moon",
  purple: "Purple",
  solarized: "Solarized",
  elysiajs: "Elysia.js",
  fastify: "Fastify",
  bluePlanet: "Blue Planet",
  saturn: "Saturn",
  kepler: "Kepler-11e",
  mars: "Mars",
  deepSpace: "Deep Space",
  laserwave: "Laserwave",
  none: ""
};
const presets = {
  default: {
    uid: "qTQR9jSM8E-LihpyZzPOi",
    name: "Default",
    description: "Default Scalar theme",
    theme: defaultTheme,
    slug: "default"
  },
  alternate: {
    uid: "2skUDSH4S8HYFF9yXysr-",
    name: "Alternate",
    description: "Alternate Scalar theme",
    theme: alternateTheme,
    slug: "alternate"
  },
  moon: {
    uid: "DG9ZUNp5lJhDeX_kPX4Bl",
    name: "Moon",
    description: "Lunar styles",
    theme: moonTheme,
    slug: "moon"
  },
  purple: {
    uid: "pE_1ysxcZ-y2LM1GGNBUv",
    name: "Purple",
    description: "Purple Scalar theme",
    theme: purpleTheme,
    slug: "purple"
  },
  solarized: {
    uid: "BdGVG1vf-4nYl3wJKyj8l",
    name: "Solarized",
    description: "Solarized Scalar theme",
    theme: solarizedTheme,
    slug: "solarized"
  },
  bluePlanet: {
    uid: "X12IfAvl7ue-42V2lW40S",
    name: "Blue Planet",
    description: "Blue Planet Scalar theme",
    theme: bluePlanetTheme,
    slug: "blue-planet"
  },
  deepSpace: {
    uid: "K8b38NWQiicq4-zXGXKdI",
    name: "Deep Space",
    description: "Deep Space Scalar theme",
    theme: deepSpaceTheme,
    slug: "deep-space"
  },
  saturn: {
    uid: "1jyAjmbIZQG-RUU4Ugk9o",
    name: "Saturn",
    description: "Saturn Scalar theme",
    theme: saturnTheme,
    slug: "saturn"
  },
  kepler: {
    uid: "jZ6dnWbtqQ0Hz3s9jLPH0",
    name: "Kepler-11e",
    description: "Kepler-11e Scalar theme",
    theme: keplerTheme,
    slug: "kepler-11e"
  },
  mars: {
    uid: "YY4LQgwiXix55-TmMz9qd",
    name: "Mars",
    description: "Mars Scalar theme",
    theme: marsTheme,
    slug: "mars"
  },
  laserwave: {
    uid: "c5fZEi-K-hP-xXf885dkf",
    name: "Laserwave",
    description: "Laserwave Scalar theme",
    theme: laserwaveTheme,
    slug: "laserwave"
  },
  elysiajs: {
    uid: "nEVZkRmCylPkT0o9YJa7y",
    name: "Elysia.js",
    description: "Elysia.js theme",
    theme: elysiajsTheme,
    slug: "elysiajs"
  },
  fastify: {
    uid: "nTZcdcM2_yHFZFxTQe9Kk",
    name: "Fastify",
    description: "Fastify theme",
    theme: fastifyTheme,
    slug: "fastify"
  }
};
const themePresets = Object.values(presets);
const getStarterTheme = (name) => ({
  name,
  slug: name.normalize("NFC").toLowerCase().trim().replace(/[^\p{L}\p{M}\p{N}\s-]/gu, "").replace(/[\s-]+/g, "-").replace(/^-+|-+$/g, "").slice(0, 255),
  description: "",
  uid: nanoid(),
  theme: customThemeStarter
});
const getThemeStyles = (themeId, opts) => {
  var _a;
  const { fonts = true, layer = "scalar-theme" } = opts ?? {};
  const styles = [
    ((_a = presets[themeId || "default"]) == null ? void 0 : _a.theme) ?? defaultTheme,
    fonts ? defaultFonts : ""
  ].join("");
  if (layer) {
    return `@layer ${layer} {
${styles}}`;
  }
  return styles;
};
export {
  alternateTheme,
  bluePlanetTheme,
  deepSpaceTheme,
  defaultFonts,
  defaultTheme,
  elysiajsTheme,
  fastifyTheme,
  getStarterTheme,
  getThemeStyles,
  hasObtrusiveScrollbars,
  keplerTheme,
  laserwaveTheme,
  marsTheme,
  moonTheme,
  presets,
  purpleTheme,
  saturnTheme,
  solarizedTheme,
  themeIds,
  themeLabels,
  themePresets
};
