const defaultTheme = "/* basic theme */\n:root {\n  --scalar-text-decoration: underline;\n  --scalar-text-decoration-hover: underline;\n}\n.light-mode {\n  --scalar-background-1: #fff;\n  --scalar-background-2: #f6f6f6;\n  --scalar-background-3: #e7e7e7;\n  --scalar-background-accent: #8ab4f81f;\n\n  --scalar-color-1: #2a2f45;\n  --scalar-color-2: #757575;\n  --scalar-color-3: #8e8e8e;\n\n  --scalar-color-accent: var(--scalar-color-1);\n  --scalar-border-color: #dfdfdf;\n}\n.dark-mode {\n  --scalar-background-1: #0f0f0f;\n  --scalar-background-2: #1a1a1a;\n  --scalar-background-3: #272727;\n\n  --scalar-color-1: #e7e7e7;\n  --scalar-color-2: #a4a4a4;\n  --scalar-color-3: #797979;\n\n  --scalar-color-accent: var(--scalar-color-1);\n  --scalar-background-accent: #3ea6ff1f;\n\n  --scalar-border-color: #2d2d2d;\n}\n/* Document Sidebar */\n.light-mode .t-doc__sidebar,\n.dark-mode .t-doc__sidebar {\n  --scalar-sidebar-background-1: var(--scalar-background-1);\n  --scalar-sidebar-color-1: var(--scalar-color-1);\n  --scalar-sidebar-color-2: var(--scalar-color-2);\n  --scalar-sidebar-border-color: var(--scalar-border-color);\n\n  --scalar-sidebar-item-hover-background: var(--scalar-background-2);\n  --scalar-sidebar-item-hover-color: currentColor;\n\n  --scalar-sidebar-item-active-background: var(--scalar-background-2);\n  --scalar-sidebar-color-active: var(--scalar-color-1);\n\n  --scalar-sidebar-indent-border: var(--scalar-sidebar-border-color);\n  --scalar-sidebar-indent-border-hover: var(--scalar-sidebar-border-color);\n  --scalar-sidebar-indent-border-active: var(--scalar-sidebar-border-color);\n\n  --scalar-sidebar-search-background: transparent;\n  --scalar-sidebar-search-color: var(--scalar-color-3);\n  --scalar-sidebar-search-border-color: var(--scalar-border-color);\n}\n/* advanced */\n.light-mode {\n  --scalar-color-green: #069061;\n  --scalar-color-red: #ef0006;\n  --scalar-color-yellow: #edbe20;\n  --scalar-color-blue: #0082d0;\n  --scalar-color-orange: #fb892c;\n  --scalar-color-purple: #5203d1;\n\n  --scalar-button-1: rgba(0, 0, 0, 1);\n  --scalar-button-1-hover: rgba(0, 0, 0, 0.8);\n  --scalar-button-1-color: rgba(255, 255, 255, 0.9);\n\n  --scalar-tooltip-background: color-mix(in srgb, #1a1a1a, transparent 10%);\n  --scalar-tooltip-color: color-mix(in srgb, #fff, transparent 15%);\n\n  --scalar-color-alert: color-mix(in srgb, var(--scalar-color-orange), var(--scalar-color-1) 20%);\n  --scalar-color-danger: color-mix(in srgb, var(--scalar-color-red), var(--scalar-color-1) 20%);\n\n  --scalar-background-alert: color-mix(in srgb, var(--scalar-color-orange), var(--scalar-background-1) 95%);\n  --scalar-background-danger: color-mix(in srgb, var(--scalar-color-red), var(--scalar-background-1) 95%);\n}\n.dark-mode {\n  --scalar-color-green: #00b648;\n  --scalar-color-red: #dc1b19;\n  --scalar-color-yellow: #ffc90d;\n  --scalar-color-blue: #4eb3ec;\n  --scalar-color-orange: #ff8d4d;\n  --scalar-color-purple: #b191f9;\n\n  --scalar-button-1: rgba(255, 255, 255, 1);\n  --scalar-button-1-hover: rgba(255, 255, 255, 0.9);\n  --scalar-button-1-color: black;\n\n  --scalar-tooltip-background: color-mix(in srgb, var(--scalar-background-1), #fff 10%);\n  --scalar-tooltip-color: color-mix(in srgb, #fff, transparent 5%);\n\n  --scalar-color-danger: color-mix(in srgb, var(--scalar-color-red), var(--scalar-background-1) 20%);\n\n  --scalar-background-alert: color-mix(in srgb, var(--scalar-color-orange), var(--scalar-background-1) 95%);\n  --scalar-background-danger: color-mix(in srgb, var(--scalar-color-red), var(--scalar-background-1) 95%);\n}\n@supports (color: color(display-p3 1 1 1)) {\n  .light-mode {\n    --scalar-color-accent: var(--scalar-color-1);\n    --scalar-color-green: color(display-p3 0.023529 0.564706 0.380392 / 1.0);\n    --scalar-color-red: color(display-p3 0.937255 0.0 0.023529 / 1.0);\n    --scalar-color-yellow: color(display-p3 0.929412 0.745098 0.12549 / 1.0);\n    --scalar-color-blue: color(display-p3 0.0 0.509804 0.815686 / 1.0);\n    --scalar-color-orange: color(display-p3 0.984314 0.537255 0.172549 / 1.0);\n    --scalar-color-purple: color(display-p3 0.321569 0.011765 0.819608 / 1.0);\n  }\n  .dark-mode {\n    --scalar-color-accent: var(--scalar-color-1);\n    --scalar-color-green: color(display-p3 0.0 0.713725 0.282353 / 1.0);\n    --scalar-color-red: color(display-p3 0.862745 0.105882 0.098039 / 1.0);\n    --scalar-color-yellow: color(display-p3 1.0 0.788235 0.05098 / 1.0);\n    --scalar-color-blue: color(display-p3 0.305882 0.701961 0.92549 / 1.0);\n    --scalar-color-orange: color(display-p3 1.0 0.552941 0.301961 / 1.0);\n    --scalar-color-purple: color(display-p3 0.694118 0.568627 0.976471 / 1.0);\n  }\n}\n";
export {
  defaultTheme as default
};
