const fastifyTheme = ".light-mode {\n  color-scheme: light;\n  --scalar-color-1: #1c1e21;\n  --scalar-color-2: #757575;\n  --scalar-color-3: #8e8e8e;\n  --scalar-color-disabled: #b4b1b1;\n  --scalar-color-ghost: #a7a7a7;\n  --scalar-color-accent: #2f8555;\n  --scalar-background-1: #fff;\n  --scalar-background-2: #f5f5f5;\n  --scalar-background-3: #ededed;\n  --scalar-background-4: rgba(0, 0, 0, 0.06);\n  --scalar-background-accent: #2f85551f;\n\n  --scalar-border-color: rgba(0, 0, 0, 0.1);\n  --scalar-scrollbar-color: rgba(0, 0, 0, 0.18);\n  --scalar-scrollbar-color-active: rgba(0, 0, 0, 0.36);\n  --scalar-lifted-brightness: 1;\n  --scalar-backdrop-brightness: 1;\n\n  --scalar-shadow-1: 0 1px 3px 0 rgba(0, 0, 0, 0.11);\n  --scalar-shadow-2: rgba(0, 0, 0, 0.08) 0px 13px 20px 0px, rgba(0, 0, 0, 0.08) 0px 3px 8px 0px, #eeeeed 0px 0 0 1px;\n\n  --scalar-button-1: rgb(49 53 56);\n  --scalar-button-1-color: #fff;\n  --scalar-button-1-hover: rgb(28 31 33);\n\n  --scalar-color-green: #007300;\n  --scalar-color-red: #af272b;\n  --scalar-color-yellow: #b38200;\n  --scalar-color-blue: #3b8ba5;\n  --scalar-color-orange: #fb892c;\n  --scalar-color-purple: #5203d1;\n}\n\n.dark-mode {\n  color-scheme: dark;\n  --scalar-color-1: rgba(255, 255, 255, 0.9);\n  --scalar-color-2: rgba(255, 255, 255, 0.62);\n  --scalar-color-3: rgba(255, 255, 255, 0.44);\n  --scalar-color-disabled: rgba(255, 255, 255, 0.34);\n  --scalar-color-ghost: rgba(255, 255, 255, 0.26);\n  --scalar-color-accent: #27c2a0;\n  --scalar-background-1: #1b1b1d;\n  --scalar-background-2: #242526;\n  --scalar-background-3: #3b3b3b;\n  --scalar-background-4: rgba(255, 255, 255, 0.06);\n  --scalar-background-accent: #27c2a01f;\n\n  --scalar-border-color: rgba(255, 255, 255, 0.1);\n  --scalar-scrollbar-color: rgba(255, 255, 255, 0.24);\n  --scalar-scrollbar-color-active: rgba(255, 255, 255, 0.48);\n  --scalar-lifted-brightness: 1.45;\n  --scalar-backdrop-brightness: 0.5;\n\n  --scalar-shadow-1: 0 1px 3px 0 rgb(0, 0, 0, 0.1);\n  --scalar-shadow-2: rgba(15, 15, 15, 0.2) 0px 3px 6px, rgba(15, 15, 15, 0.4) 0px 9px 24px, 0 0 0 1px\n    rgba(255, 255, 255, 0.1);\n\n  --scalar-button-1: #f6f6f6;\n  --scalar-button-1-color: #000;\n  --scalar-button-1-hover: #e7e7e7;\n\n  --scalar-color-green: #26b226;\n  --scalar-color-red: #fb565b;\n  --scalar-color-yellow: #ffc426;\n  --scalar-color-blue: #6ecfef;\n  --scalar-color-orange: #ff8d4d;\n  --scalar-color-purple: #b191f9;\n}\n";
export {
  fastifyTheme as default
};
