const laserwaveTheme = "/* basic theme */\n.light-mode {\n  color-scheme: light;\n  --scalar-color-1: #322b3b;\n  --scalar-color-2: #645676;\n  --scalar-color-3: #9789a9;\n  --scalar-color-accent: #40b4c4;\n\n  --scalar-background-1: #fff;\n  --scalar-background-2: #f4f2f7;\n  --scalar-background-3: #cfc7dc;\n  --scalar-background-accent: #f3fafb;\n\n  --scalar-border-color: #e4e0eb;\n}\n.dark-mode {\n  color-scheme: dark;\n  --scalar-color-1: #fff;\n  --scalar-color-2: #b8b6ba;\n  --scalar-color-3: #706c74;\n  --scalar-color-accent: #ed78c2;\n\n  --scalar-background-1: #27212e;\n  --scalar-background-2: #322c39;\n  --scalar-background-3: #4c4059;\n  --scalar-background-accent: #eb64b91f;\n\n  --scalar-border-color: rgba(255, 255, 255, 0.1);\n}\n\n/* Sidebar */\n.light-mode .t-doc__sidebar {\n  --scalar-sidebar-background-1: var(--scalar-background-1);\n  --scalar-sidebar-item-hover-color: currentColor;\n  --scalar-sidebar-item-hover-background: var(--scalar-background-2);\n  --scalar-sidebar-item-active-background: var(--scalar-background-accent);\n  --scalar-sidebar-border-color: var(--scalar-border-color);\n  --scalar-sidebar-color-1: var(--scalar-color-1);\n  --scalar-sidebar-color-2: var(--scalar-color-2);\n  --scalar-sidebar-color-active: var(--scalar-color-accent);\n  --scalar-sidebar-search-background: var(--scalar-background-2);\n  --scalar-sidebar-search-border-color: var(--scalar-sidebar-border-color);\n  --scalar-sidebar-search--color: var(--scalar-color-3);\n}\n.dark-mode .t-doc__sidebar {\n  --scalar-sidebar-background-1: var(--scalar-background-1);\n  --scalar-sidebar-item-hover-color: currentColor;\n  --scalar-sidebar-item-hover-background: var(--scalar-background-2);\n  --scalar-sidebar-item-active-background: var(--scalar-background-accent);\n  --scalar-sidebar-border-color: var(--scalar-border-color);\n  --scalar-sidebar-color-1: var(--scalar-color-1);\n  --scalar-sidebar-color-2: var(--scalar-color-2);\n  --scalar-sidebar-color-active: var(--scalar-color-accent);\n  --scalar-sidebar-search-background: var(--scalar-background-2);\n  --scalar-sidebar-search-border-color: #514c56;\n  --scalar-sidebar-search--color: var(--scalar-color-3);\n}\n/* advanced */\n.light-mode {\n  --scalar-button-1: rgb(49 53 56);\n  --scalar-button-1-color: #fff;\n  --scalar-button-1-hover: rgb(28 31 33);\n\n  --scalar-color-green: #74dfc4;\n  --scalar-color-red: #d887f5;\n  --scalar-color-yellow: #ffe261;\n  --scalar-color-blue: #40b4c4;\n  --scalar-color-orange: #ff52bf;\n  --scalar-color-purple: #91889b;\n\n  --scalar-scrollbar-color: rgba(0, 0, 0, 0.18);\n  --scalar-scrollbar-color-active: rgba(0, 0, 0, 0.36);\n}\n.dark-mode {\n  --scalar-button-1: #f6f6f6;\n  --scalar-button-1-color: #27212e;\n  --scalar-button-1-hover: #e7e7e7;\n\n  --scalar-color-green: #74dfc4;\n  --scalar-color-red: #d887f5;\n  --scalar-color-yellow: #ffe261;\n  --scalar-color-blue: #40b4c4;\n  --scalar-color-orange: #ff52bf;\n  --scalar-color-purple: #91889b;\n\n  --scalar-scrollbar-color: rgba(255, 255, 255, 0.24);\n  --scalar-scrollbar-color-active: rgba(255, 255, 255, 0.48);\n}\n/* Radius */\n:root {\n  --scalar-radius: 2px;\n  --scalar-radius-lg: 3px;\n  --scalar-radius-xl: 4px;\n}\n/* P3 color support */\n@supports (color: color(display-p3 1 1 1)) {\n  .light-mode {\n    --scalar-color-accent: color(display-p3 0.25098 0.705882 0.768627 / 1.0);\n    --scalar-color-green: color(display-p3 0.454902 0.87451 0.768627 / 1.0);\n    --scalar-color-red: color(display-p3 0.847059 0.529412 0.960784 / 1.0);\n    --scalar-color-yellow: color(display-p3 1.0 0.886275 0.380392 / 1.0);\n    --scalar-color-blue: color(display-p3 0.25098 0.705882 0.768627 / 1.0);\n    --scalar-color-orange: color(display-p3 1.0 0.321569 0.74902 / 1.0);\n    --scalar-color-purple: color(display-p3 0.568627 0.533333 0.607843 / 1.0);\n  }\n  .dark-mode {\n    --scalar-color-accent: color(display-p3 0.929412 0.470588 0.760784 / 1.0);\n    --scalar-color-green: color(display-p3 0.454902 0.87451 0.768627 / 1.0);\n    --scalar-color-red: color(display-p3 0.847059 0.529412 0.960784 / 1.0);\n    --scalar-color-yellow: color(display-p3 1.0 0.886275 0.380392 / 1.0);\n    --scalar-color-blue: color(display-p3 0.25098 0.705882 0.768627 / 1.0);\n    --scalar-color-orange: color(display-p3 1.0 0.321569 0.74902 / 1.0);\n    --scalar-color-purple: color(display-p3 0.568627 0.533333 0.607843 / 1.0);\n  }\n}\n";
export {
  laserwaveTheme as default
};
