const moonTheme = ".light-mode {\n  color-scheme: light;\n  --scalar-color-1: #000000;\n  --scalar-color-2: #000000;\n  --scalar-color-3: #000000;\n  --scalar-color-accent: #645b0f;\n  --scalar-background-1: #ccc9b3;\n  --scalar-background-2: #c2bfaa;\n  --scalar-background-3: #b8b5a1;\n  --scalar-background-accent: #000000;\n\n  --scalar-border-color: rgba(0, 0, 0, 0.2);\n  --scalar-scrollbar-color: rgba(0, 0, 0, 0.18);\n  --scalar-scrollbar-color-active: rgba(0, 0, 0, 0.36);\n  --scalar-lifted-brightness: 1;\n  --scalar-backdrop-brightness: 1;\n\n  --scalar-shadow-1: 0 1px 3px 0 rgba(0, 0, 0, 0.11);\n  --scalar-shadow-2: rgba(0, 0, 0, 0.08) 0px 13px 20px 0px, rgba(0, 0, 0, 0.08) 0px 3px 8px 0px,\n    var(--scalar-border-color) 0px 0 0 1px;\n\n  --scalar-button-1: rgb(49 53 56);\n  --scalar-button-1-color: #fff;\n  --scalar-button-1-hover: rgb(28 31 33);\n\n  --scalar-color-red: #b91c1c;\n  --scalar-color-orange: #a16207;\n  --scalar-color-green: #047857;\n  --scalar-color-blue: #1d4ed8;\n  --scalar-color-orange: #c2410c;\n  --scalar-color-purple: #6d28d9;\n}\n\n.dark-mode {\n  color-scheme: dark;\n  --scalar-color-1: #fffef3;\n  --scalar-color-2: #fffef3;\n  --scalar-color-3: #fffef3;\n  --scalar-color-accent: #c3b531;\n  --scalar-background-1: #313332;\n  --scalar-background-2: #393b3a;\n  --scalar-background-3: #414342;\n  --scalar-background-accent: #fffef3;\n\n  --scalar-border-color: #505452;\n  --scalar-scrollbar-color: rgba(255, 255, 255, 0.24);\n  --scalar-scrollbar-color-active: rgba(255, 255, 255, 0.48);\n  --scalar-lifted-brightness: 1.45;\n  --scalar-backdrop-brightness: 0.5;\n\n  --scalar-shadow-1: 0 1px 3px 0 rgba(0, 0, 0, 0.11);\n  --scalar-shadow-2: rgba(15, 15, 15, 0.2) 0px 3px 6px, rgba(15, 15, 15, 0.4) 0px 9px 24px, 0 0 0 1px\n    rgba(255, 255, 255, 0.1);\n\n  --scalar-button-1: #f6f6f6;\n  --scalar-button-1-color: #000;\n  --scalar-button-1-hover: #e7e7e7;\n\n  --scalar-color-green: #00b648;\n  --scalar-color-red: #dc1b19;\n  --scalar-color-yellow: #ffc90d;\n  --scalar-color-blue: #4eb3ec;\n  --scalar-color-orange: #ff8d4d;\n  --scalar-color-purple: #b191f9;\n}\n\n/* Sidebar */\n.light-mode .t-doc__sidebar,\n.dark-mode .t-doc__sidebar {\n  --scalar-sidebar-background-1: var(--scalar-background-1);\n  --scalar-sidebar-color-1: var(--scalar-color-1);\n  --scalar-sidebar-color-2: var(--scalar-color-2);\n  --scalar-sidebar-border-color: var(--scalar-border-color);\n\n  --scalar-sidebar-item-hover-background: var(--scalar-background-2);\n  --scalar-sidebar-item-hover-color: currentColor;\n\n  --scalar-sidebar-item-active-background: var(--scalar-background-3);\n  --scalar-sidebar-color-active: var(--scalar-color-1);\n\n  --scalar-sidebar-search-background: transparent;\n  --scalar-sidebar-search-color: var(--scalar-color-3);\n  --scalar-sidebar-search-border-color: var(--scalar-border-color);\n}\n*::selection {\n  background-color: color-mix(in srgb, var(--scalar-color-accent), transparent 80%);\n}\n";
export {
  moonTheme as default
};
