import { watch } from "vue";
function useDropdown(params) {
  const { codeMirror, query, showDropdown, dropdownPosition } = params;
  function getCursorPos() {
    return codeMirror.value?.state.selection.main.head || 0;
  }
  function getCoordsAtPos(pos) {
    return codeMirror.value?.coordsAtPos(pos);
  }
  function updateDropdownPosition() {
    const cursorPos = getCursorPos();
    requestAnimationFrame(() => {
      const coords = getCoordsAtPos(cursorPos - query.value.length - 2);
      if (coords) {
        dropdownPosition.value = {
          left: coords.left,
          top: Math.max(coords.bottom)
        };
      }
    });
  }
  watch(query, updateDropdownPosition);
  function handleDropdownSelect(item) {
    const formattedItem = `{{${item}}}`;
    const cursor = getCursorPos();
    const from = Math.max(0, cursor - query.value.length - 2);
    const to = cursor;
    codeMirror.value?.dispatch({
      changes: { from, to, insert: formattedItem }
    });
    showDropdown.value = false;
  }
  function updateDropdownVisibility() {
    const cursor = getCursorPos();
    const text = codeMirror.value?.state.doc.sliceString(0, cursor) || "";
    const lastOpenBraceIndex = text.lastIndexOf("{{");
    const lastCloseBraceIndex = text.lastIndexOf("}}");
    if (lastOpenBraceIndex > lastCloseBraceIndex) {
      query.value = text.slice(lastOpenBraceIndex + 2);
      showDropdown.value = true;
      dropdownPosition.value = getCoordsAtPos(cursor) || { left: 0, top: 0 };
      if (query.value === "") {
        updateDropdownPosition();
      }
    } else {
      showDropdown.value = false;
    }
  }
  watch(() => codeMirror.value?.state.doc.toString(), updateDropdownVisibility);
  return {
    handleDropdownSelect,
    updateDropdownVisibility
  };
}
export {
  useDropdown
};
//# sourceMappingURL=useDropdown.js.map
