/**
 * Tailwind Merge Config
 *
 * By default tailwind merge only knows about the default tailwind classes
 * this is because it does not load in the tailwind config at runtime (perf reasons)
 * we must specify any custom classes if they are getting overwritten
 *
 * https://github.com/dcastil/tailwind-merge/blob/v2.0.0/docs/configuration.md#class-groups
 */
declare const tw: (...classLists: import("tailwind-merge").ClassNameValue[]) => string;
/**
 * CVA Config
 *
 * https://beta.cva.style/api-reference/#defineconfig
 */
declare const cva: import("cva").CVA, cx: import("cva").CX, compose: import("cva").Compose;
export { cva, cx, compose, tw };
//# sourceMappingURL=cva.d.ts.map