import { defineConfig } from "cva";
import { extendTailwindMerge } from "tailwind-merge";
const tw = extendTailwindMerge({
  extend: {
    classGroups: {
      "font-size": ["text-3xs", "text-xxs"]
    }
  }
});
const { cva, cx, compose } = defineConfig({
  hooks: {
    onComplete: (className) => tw(className)
  }
});
export {
  compose,
  cva,
  cx,
  tw
};
//# sourceMappingURL=cva.js.map
