import { computed, useAttrs } from "vue";
import { cx } from "./cva.js";
function useBindCx() {
  const attrs = useAttrs();
  const destructured = computed(() => {
    const { class: className, ...rest } = attrs;
    return { class: className || "", rest };
  });
  function bindCx(...args) {
    return {
      class: cx(...args, destructured.value.class),
      ...destructured.value.rest
    };
  }
  function bindClass(...args) {
    return { class: cx(...args, destructured.value.class) };
  }
  return {
    /**
     * Provides a wrapper around the `cx` function that merges the
     * component's class attribute with the provided classes and binds the
     * remaining attributes
     *
     * @example
     * <script setup>
     * ...
     * const { cx } = useBindCx()
     * <\/script>
     * <template>
     *   <div v-bind="cx(...)">...</div>
     * </template>
     */
    cx: bindCx,
    /**
     * Provides a wrapper around the `cx` function that merges the
     * component's class attribute with the provided classes and but **does
     * not** bind the remaining attributes
     */
    classCx: bindClass,
    /** The remaining attributes that are not class attributes */
    otherAttrs: computed(() => destructured.value.rest)
  };
}
export {
  useBindCx
};
//# sourceMappingURL=useBindCx.js.map
