import { screens } from "./constants.js";
import { useMediaQuery } from "@vueuse/core";
import { computed, unref } from "vue";
function useBreakpoints() {
  const mediaQueries = Object.fromEntries(
    Object.entries(screens).map(([breakpoint, value]) => [breakpoint, useMediaQuery(value)])
  );
  const breakpoints = computed(
    () => Object.fromEntries(
      Object.entries(mediaQueries).map(([breakpoint, queryRef]) => [breakpoint, unref(queryRef)])
    )
  );
  return {
    /** The screen sizes defined in the preset */
    screens,
    /** Reactive media queries for each of the screen sizes */
    mediaQueries,
    /** The breakpoints as reactive media queries */
    breakpoints
  };
}
export {
  useBreakpoints
};
//# sourceMappingURL=useBreakpoints.js.map
