import { useToasts } from "@scalar/use-toasts";
function useClipboard(opts = {}) {
  const { notify = (m) => toast(m, "info") } = opts;
  const { toast } = useToasts();
  async function copyToClipboard(value) {
    try {
      await navigator.clipboard.writeText(value);
      notify("Copied to the clipboard");
    } catch (e) {
      const error = e;
      console.error(error.message);
      notify("Failed to copy to clipboard");
    }
  }
  return { copyToClipboard };
}
export {
  useClipboard
};
//# sourceMappingURL=useClipboard.js.map
