import { Optional, Brush, BrushJSON, DataCaptureOverlay, DataCaptureView, PrivateDataCaptureMode, DataCaptureMode, CameraSettings, DataCaptureContext, DataCaptureModeJSON } from 'scandit-web-datacapture-core';
import { Serializable } from 'scandit-web-datacapture-core/build/js/private/Serializable';
import { BarcodeTrackingSession } from './BarcodeTrackingSession.js';
import { BarcodeTrackingSettings, BarcodeTrackingSettingsJSON } from './BarcodeTrackingSettings.js';
import { TrackedBarcode, TrackedBarcodeJSON } from './TrackedBarcode.js';

interface BarcodeTrackingBasicOverlayListener {
    brushForTrackedBarcode?(overlay: BarcodeTrackingBasicOverlay, trackedBarcode: TrackedBarcode): Optional<Brush>;
    didTapTrackedBarcode?(overlay: BarcodeTrackingBasicOverlay, trackedBarcode: TrackedBarcode): void;
}
declare enum BarcodeTrackingBasicOverlayStyle {
    Frame = "frame",
    Dot = "dot",
    /**
     * @deprecated The BarcodeTrackingBasicOverlayStyle is deprecated and will be removed in the future.
     */
    Legacy = "legacy"
}
interface BarcodeTrackingBasicOverlayJSON {
    type: "barcodeTrackingBasic";
    style: BarcodeTrackingBasicOverlayStyle;
    shouldShowScanAreaGuides: boolean;
    brush: BrushJSON;
    brushesForBarcodes: Record<string, BrushJSON>;
}
declare class BarcodeTrackingBasicOverlay implements DataCaptureOverlay, Serializable<BarcodeTrackingBasicOverlayJSON> {
    private _listener;
    private privateListener;
    private readonly type;
    private _style;
    private barcodeTracking;
    private _shouldShowScanAreaGuides;
    private _brush;
    private _brushesForBarcodes;
    get style(): BarcodeTrackingBasicOverlayStyle;
    get listener(): Optional<BarcodeTrackingBasicOverlayListener>;
    set listener(listener: Optional<BarcodeTrackingBasicOverlayListener>);
    get brush(): Brush;
    static withBarcodeTracking(barcodeTracking: BarcodeTracking): Promise<BarcodeTrackingBasicOverlay>;
    static withBarcodeTrackingForView(barcodeTracking: BarcodeTracking, view: Optional<DataCaptureView>): Promise<BarcodeTrackingBasicOverlay>;
    static withBarcodeTrackingForViewWithStyle(barcodeTracking: BarcodeTracking, view: Optional<DataCaptureView>, style: BarcodeTrackingBasicOverlayStyle): Promise<BarcodeTrackingBasicOverlay>;
    setBrush(brush: Brush): Promise<void>;
    shouldShowScanAreaGuides(): boolean;
    setShouldShowScanAreaGuides(shouldShowScanAreaGuides: boolean): Promise<void>;
    setBrushForTrackedBarcode(brush: Brush, trackedBarcode: TrackedBarcode): Promise<void>;
    clearTrackedBarcodeBrushes(): Promise<void>;
    toJSONObject(): BarcodeTrackingBasicOverlayJSON;
}

interface PrivateBarcodeTrackingListener extends BarcodeTrackingListener {
    didTapTrackedBarcode?(trackedBarcode: TrackedBarcodeJSON): void;
}
declare class PrivateBarcodeTrackingBasicOverlayListener implements PrivateBarcodeTrackingListener {
    private basicOverlay;
    constructor(basicOverlay: BarcodeTrackingBasicOverlay);
    didTapTrackedBarcode(trackedBarcode: TrackedBarcodeJSON): void;
    didUpdateSession(_: BarcodeTracking, session: BarcodeTrackingSession): void;
}

interface PrivateBarcodeTracking extends PrivateDataCaptureMode {
    notifyContext: () => Promise<void>;
    addPrivateListener(listener: PrivateBarcodeTrackingListener): void;
}
interface BarcodeTrackingListener {
    didUpdateSession?(barcodeTracking: BarcodeTracking, session: BarcodeTrackingSession): void;
}
type BarcodeTrackingJSON = DataCaptureModeJSON<BarcodeTrackingSettingsJSON>;
declare class BarcodeTracking implements DataCaptureMode, Serializable<BarcodeTrackingJSON> {
    private readonly type;
    private _isEnabled;
    private settings;
    private _context;
    private readonly listeners;
    private readonly privateListeners;
    private readonly workerMessageListener;
    static get recommendedCameraSettings(): CameraSettings;
    get context(): DataCaptureContext | null;
    private set context(value);
    static forContext(context: DataCaptureContext | null, settings: BarcodeTrackingSettings): Promise<BarcodeTracking>;
    isEnabled(): boolean;
    setEnabled(enabled: boolean): Promise<void>;
    applySettings(settings: BarcodeTrackingSettings): Promise<void>;
    addListener(listener: BarcodeTrackingListener): void;
    removeListener(listener: BarcodeTrackingListener): void;
    toJSONObject(): BarcodeTrackingJSON;
    private attachedToContext;
    private detachedFromContext;
    private addPrivateListener;
    private removePrivateListener;
    private onWorkerMessage;
    private notifyContext;
}

export { type BarcodeTrackingListener as B, type PrivateBarcodeTracking as P, BarcodeTracking as a, type BarcodeTrackingBasicOverlayListener as b, BarcodeTrackingBasicOverlayStyle as c, type BarcodeTrackingBasicOverlayJSON as d, BarcodeTrackingBasicOverlay as e, type PrivateBarcodeTrackingListener as f, PrivateBarcodeTrackingBasicOverlayListener as g };
