import { Anchor, PointWithUnit, DataCaptureOverlay, DataCaptureView } from 'scandit-web-datacapture-core';
import { Serializable } from 'scandit-web-datacapture-core/build/js/private/Serializable';
import { a as BarcodeTracking } from './BarcodeTracking-C_jbHwi-.js';
import { TrackedBarcode } from './TrackedBarcode.js';
import { TrackedBarcodeView } from './TrackedBarcodeView.js';
import './BarcodeTrackingSession.js';
import './BarcodeTrackingSettings.js';
import './Barcode.js';
import './EncodingRange.js';
import './StructuredAppendData.js';
import './SymbologySettings.js';
import './private/symbols.js';

interface BarcodeTrackingAdvancedOverlayListener {
    viewForTrackedBarcode?(overlay: BarcodeTrackingAdvancedOverlay, trackedBarcode: TrackedBarcode): Promise<TrackedBarcodeView | null>;
    anchorForTrackedBarcode?(overlay: BarcodeTrackingAdvancedOverlay, trackedBarcode: TrackedBarcode): Anchor;
    offsetForTrackedBarcode?(overlay: BarcodeTrackingAdvancedOverlay, trackedBarcode: TrackedBarcode): PointWithUnit;
    didTapViewForTrackedBarcode?(overlay: BarcodeTrackingAdvancedOverlay, trackedBarcode: TrackedBarcode): void;
}
interface BarcodeTrackingAdvancedOverlayJSON {
    type: "barcodeTrackingAdvanced";
    shouldShowScanAreaGuides: boolean;
}
declare class BarcodeTrackingAdvancedOverlay implements DataCaptureOverlay, Serializable<BarcodeTrackingAdvancedOverlayJSON> {
    listener: BarcodeTrackingAdvancedOverlayListener | null;
    private readonly type;
    private barcodeTracking;
    private _shouldShowScanAreaGuides;
    private _viewForBarcode;
    private _anchorForBarcode;
    private _offsetForBarcode;
    private _viewForBarcodeFromListener;
    private _anchorForBarcodeFromListener;
    private _offsetForBarcodeFromListener;
    private _anchorPositions;
    private _barcodeForId;
    private privateListener;
    private view;
    private lastSession;
    get shouldShowScanAreaGuides(): boolean;
    set shouldShowScanAreaGuides(shouldShow: boolean);
    static withBarcodeTrackingForView(barcodeTracking: BarcodeTracking, view: DataCaptureView | null): Promise<BarcodeTrackingAdvancedOverlay>;
    setViewForTrackedBarcode(view: Promise<TrackedBarcodeView | null> | null, trackedBarcode: TrackedBarcode): Promise<void>;
    setAnchorForTrackedBarcode(anchor: Anchor, trackedBarcode: TrackedBarcode): void;
    setOffsetForTrackedBarcode(offset: PointWithUnit, trackedBarcode: TrackedBarcode): void;
    clearTrackedBarcodeViews(): void;
    toJSONObject(): BarcodeTrackingAdvancedOverlayJSON;
    private getTrackedBarcodeForIdentifier;
    private setViewForTrackedBarcodeFromListener;
    private processRemovedBarcodes;
    private processAddedBarcodes;
    private processUpdatedTrackedBarcodes;
    /**
     * Used in PrivateBarcodeTrackingAdvancedOverlayListener.
     * Triggers a render into the view
     * @param session {BarcodeTrackingSession}
     * @private
     * @hidden
     */
    private update;
}

export { BarcodeTrackingAdvancedOverlay, type BarcodeTrackingAdvancedOverlayJSON, type BarcodeTrackingAdvancedOverlayListener };
