import { Color, CameraSettings, MeasureUnit, TorchState, CameraSettingsJSON } from 'scandit-web-datacapture-core';
import { CameraSettingsDefaultsJSON } from 'scandit-web-datacapture-core/build/js/Defaults';
import { Symbology, PrivateCompositeTypeDescription } from './Barcode.js';
import { SymbologyDescription } from './SymbologyDescription.js';
import { SymbologySettings } from './SymbologySettings.js';
import { SparkScanViewHandMode } from './spark/ui/SparkScanViewHandMode.js';
import 'scandit-web-datacapture-core/build/js/private/Serializable';
import './EncodingRange.js';
import './StructuredAppendData.js';
import './Range.js';

type BarcodeCaptureOverlayStyle = any;
type BarcodeTrackingBasicOverlayStyle = any;
interface Defaults {
    SymbologySettings: {
        [key in Symbology]: SymbologySettings;
    };
    SymbologyDescriptions: SymbologyDescription[];
    CompositeTypeDescriptions: PrivateCompositeTypeDescription[];
    BarcodeCapture: {
        BarcodeCaptureOverlay: {
            defaultStyle: BarcodeCaptureOverlayStyle;
            DefaultBrush: {
                fillColor: Color;
                strokeColor: Color;
                strokeWidth: number;
            };
            styles: {
                [key in BarcodeCaptureOverlayStyle]: {
                    DefaultBrush: {
                        fillColor: Color;
                        strokeColor: Color;
                        strokeWidth: number;
                    };
                };
            };
        };
        BarcodeCaptureSettings: {
            codeDuplicateFilter: number;
        };
        RecommendedCameraSettings: CameraSettings;
    };
    BarcodeTracking: {
        BarcodeTrackingBasicOverlay: {
            defaultStyle: BarcodeTrackingBasicOverlayStyle;
            DefaultBrush: {
                fillColor: Color;
                strokeColor: Color;
                strokeWidth: number;
            };
            styles: {
                [key in BarcodeTrackingBasicOverlayStyle]: {
                    DefaultBrush: {
                        fillColor: Color;
                        strokeColor: Color;
                        strokeWidth: number;
                    };
                };
            };
        };
        RecommendedCameraSettings: CameraSettings;
    };
    SparkScan: {
        SparkScanFeedback: {
            errorVibrationPattern: number[];
        };
        SparkScanSettings: {
            codeDuplicateFilter: number;
            locationSelection: {
                radius: number;
                unit: MeasureUnit;
            };
            targetModeLocationSelection: {
                radius: number;
                unit: MeasureUnit;
            };
            hiddenProperties: {
                zoom1x: {
                    motion_scan_suppression_mode: number;
                };
                zoom2x: {
                    motion_scan_suppression_mode: number;
                };
            };
        };
        SparkScanOverlay: {
            defaultStyle: BarcodeTrackingBasicOverlayStyle;
            DefaultBrush: {
                fillColor: Color;
                strokeColor: Color;
                strokeWidth: number;
            };
        };
        CameraSettings: {
            settings: CameraSettings;
            hiddenProperties: {
                exposureTargetBias: number;
                repeatedTriggerInterval: number;
                grayScaleFrameReader: boolean;
            };
        };
        SparkScanViewSettings: {
            triggerButtonCollapseTimeout: number;
            defaultTorchState: TorchState;
            soundEnabled: boolean;
            hapticEnabled: boolean;
            defaultHandMode: SparkScanViewHandMode;
            holdToScanEnabled: boolean;
            visualFeedbackEnabled: boolean;
            inactiveStateTimeout: number;
            zoomFactorOut: number;
            zoomFactorIn: number;
        };
    };
    SparkCapture: {
        SparkCaptureSettings: {
            codeDuplicateFilter: number;
        };
    };
}
interface DefaultsJSON {
    SymbologySettings: {
        [key in Symbology]: string;
    };
    SymbologyDescriptions: string[];
    CompositeTypeDescriptions: string[];
    BarcodeCapture: {
        BarcodeCaptureOverlay: {
            defaultStyle: BarcodeCaptureOverlayStyle;
            DefaultBrush: {
                fillColor: string;
                strokeColor: string;
                strokeWidth: number;
            };
            styles: Record<string, {
                DefaultBrush: {
                    fillColor: string;
                    strokeColor: string;
                    strokeWidth: number;
                };
            }>;
        };
        BarcodeCaptureSettings: {
            codeDuplicateFilter: number;
        };
        RecommendedCameraSettings: CameraSettingsDefaultsJSON;
    };
    BarcodeTracking: {
        BarcodeTrackingBasicOverlay: {
            defaultStyle: BarcodeTrackingBasicOverlayStyle;
            DefaultBrush: {
                fillColor: string;
                strokeColor: string;
                strokeWidth: number;
            };
            styles: Record<string, {
                DefaultBrush: {
                    fillColor: string;
                    strokeColor: string;
                    strokeWidth: number;
                };
            }>;
        };
        RecommendedCameraSettings: CameraSettingsDefaultsJSON;
    };
    SparkScan: {
        SparkScanFeedback: {
            errorVibrationPattern: number[];
        };
        SparkScanSettings: {
            codeDuplicateFilter: number;
            locationSelection: {
                radius: number;
                unit: MeasureUnit;
            };
            targetModeLocationSelection: {
                radius: number;
                unit: MeasureUnit;
            };
            hiddenProperties: {
                zoom1x: {
                    motion_scan_suppression_mode: number;
                };
                zoom2x: {
                    motion_scan_suppression_mode: number;
                };
            };
        };
        SparkScanOverlay: {
            defaultStyle: BarcodeTrackingBasicOverlayStyle;
            DefaultBrush: {
                fillColor: string;
                strokeColor: string;
                strokeWidth: number;
            };
        };
        CameraSettings: {
            settings: CameraSettingsJSON;
            hiddenProperties: {
                exposureTargetBias: number;
                repeatedTriggerInterval: number;
                grayScaleFrameReader: boolean;
            };
        };
        SparkScanViewSettings: {
            triggerButtonCollapseTimeout: number;
            defaultTorchState: TorchState;
            soundEnabled: boolean;
            hapticEnabled: boolean;
            defaultHandMode: SparkScanViewHandMode;
            holdToScanEnabled: boolean;
            visualFeedbackEnabled: boolean;
            inactiveStateTimeout: number;
            zoomFactorOut: number;
            zoomFactorIn: number;
        };
    };
    SparkCapture: {
        SparkCaptureSettings: {
            codeDuplicateFilter: number;
        };
    };
}
declare const defaultsFromJSON: (json: DefaultsJSON) => Defaults;
declare let defaultValues: Defaults;
declare function setDefaults(newDefaults: Defaults): void;

export { type Defaults, type DefaultsJSON, defaultValues, defaultsFromJSON, setDefaults };
