import { Symbology } from './Barcode.js';
import { RangeJSON, Range } from './Range.js';
import 'scandit-web-datacapture-core';
import 'scandit-web-datacapture-core/build/js/private/Serializable';
import './EncodingRange.js';
import './StructuredAppendData.js';

interface SymbologyDescriptionJSON {
    activeSymbolCountRange: RangeJSON;
    defaultSymbolCountRange: RangeJSON;
    identifier: string;
    isAvailable: boolean;
    isColorInvertible: boolean;
    readableName: string;
    supportedExtensions: string[];
}
declare class SymbologyDescription {
    private static defaults;
    private _activeSymbolCountRange;
    private _defaultSymbolCountRange;
    private _identifier;
    private _isAvailable;
    private _isColorInvertible;
    private _readableName;
    private _supportedExtensions;
    constructor(symbology?: Symbology);
    static get all(): SymbologyDescription[];
    get activeSymbolCountRange(): Range;
    get defaultSymbolCountRange(): Range;
    get identifier(): string;
    get isAvailable(): boolean;
    get isColorInvertible(): boolean;
    get readableName(): string;
    get supportedExtensions(): string[];
    get symbology(): Symbology;
    static forIdentifier(identifier: string): SymbologyDescription | null;
    private static fromJSON;
}

export { SymbologyDescription, type SymbologyDescriptionJSON };
