import { Serializable } from 'scandit-web-datacapture-core/build/js/private/Serializable';
import { Checksum, Symbology } from './Barcode.js';
import 'scandit-web-datacapture-core';
import './EncodingRange.js';
import './StructuredAppendData.js';

interface SymbologySettingsJSON {
    activeSymbolCounts: number[];
    checksums: string[];
    colorInvertedEnabled: boolean;
    enabled: boolean;
    extensions: string[];
}
declare class SymbologySettings implements Serializable<SymbologySettingsJSON> {
    activeSymbolCounts: number[];
    checksums: Set<Checksum>;
    isColorInvertedEnabled: boolean;
    isEnabled: boolean;
    private _symbology;
    private extensions;
    get enabledExtensions(): string[];
    get symbology(): Symbology;
    private static fromJSON;
    setExtensionEnabled(extension: string, enabled: boolean): void;
    toJSONObject(): SymbologySettingsJSON;
}

export { SymbologySettings, type SymbologySettingsJSON };
