import { Size, SizeJSON } from 'scandit-web-datacapture-core';
import { Serializable } from 'scandit-web-datacapture-core/build/js/private/Serializable';
import { stripImages } from './private/symbols.js';

interface PrivateTrackedBarcodeView {
    data: string;
    getEncodedImageData: (element: HTMLElement) => string;
}
interface PrivateTrackedBarcodeViewOptions {
    size: Size;
    scale?: number;
}
interface TrackedBarcodeViewOptionsJSON {
    size: SizeJSON;
    scale?: number;
}
interface TrackedBarcodeViewOptions {
    size?: Size;
    scale?: number;
}
interface TrackedBarcodeViewJSON {
    data: string;
    options: TrackedBarcodeViewOptionsJSON;
}
declare class TrackedBarcodeView implements Serializable<TrackedBarcodeViewJSON> {
    private static [stripImages];
    private readonly data;
    private readonly options;
    private constructor();
    static withHTMLElement(element: HTMLElement, options: TrackedBarcodeViewOptions | null): Promise<TrackedBarcodeView>;
    static withBase64EncodedData(data: string, options: TrackedBarcodeViewOptions | null): Promise<TrackedBarcodeView>;
    private static getEncodedImageData;
    private static getSize;
    private static getSVGDataForElement;
    private static getCanvasWithSize;
    private static getBase64DataFromDataURL;
    toJSONObject(): TrackedBarcodeViewJSON;
}

export { type PrivateTrackedBarcodeView, type PrivateTrackedBarcodeViewOptions, TrackedBarcodeView, type TrackedBarcodeViewJSON, type TrackedBarcodeViewOptions };
