import { Logger, DataCaptureVersion, DataCaptureError } from 'scandit-web-datacapture-core';
import { getLibraryLocationURIs } from 'scandit-web-datacapture-core/build/js/private/Helper.js';
import { hasSIMDSupport, checkFullMultithreadingSupport } from 'scandit-web-datacapture-core/build/js/private/multithreadSimdHelper.js';
import { Deferred } from 'scandit-web-datacapture-core/build/js/private/utils/deferred.js';
import { isWorkerScope } from 'scandit-web-datacapture-core/build/js/private/utils/isWorkerScope.js';
import { instantiateWebAssembly } from 'scandit-web-datacapture-core/build/js/worker/helper.js';
import { importWasmScript } from 'scandit-web-datacapture-core/build/js/worker/importWasmScript.js';

var w=t=>t.result!=null&&t.error==null;function l(t,e){return {type:"djinniResult",payload:{id:t.id,className:t.className,methodName:t.methodName,instanceId:t.instanceId,result:e}}}function W(t){try{return {type:"result",result:JSON.parse(t)}}catch(e){return {type:"error",error:e}}}var M=class{constructor(e,r){this.parsers=new Map;this.onMessageListener=this.onMessage.bind(this);this.setupPromise=null;this.workerSelf=e,this.moduleHandler=r,isWorkerScope(e)&&(this.workerFunctions={postMessage:this.workerSelf.postMessage.bind(this.workerSelf)},this.listenToMessages());}get Module(){return this.moduleHandler.get()}listenToMessages(){this.workerSelf.addEventListener("message",this.onMessageListener),this.workerSelf.addEventListener("error",e=>{Logger.log(Logger.Level.Error,e);}),this.workerSelf.addEventListener("messageerror",e=>{Logger.log(Logger.Level.Error,e);});}onMessage(e){return this.performDjinniAction(e.data),!0}async performDjinniAction(e){var n,i;let r;if(Logger.log(Logger.Level.Debug,`ParserMode:performDjinniAction for class: ${e.className}, method: ${e.methodName}`,e.args),e.methodName==="create"){let p=e.args[0].toString();if(this.parsers.has(p)){this.workerFunctions.postMessage(l(e,{type:"result",result:p}));return}try{await this.setup(e.args[1]);}catch(d){this.workerFunctions.postMessage(l(e,{type:"error",error:d}));return}r=this.createParser(e),Logger.log(Logger.Level.Debug,r),this.workerFunctions.postMessage(r);return}let o=this.parsers.get((n=e.instanceId)!=null?n:"");if(o==null){this.workerFunctions.postMessage(l(e,{type:"error",error:`parser is not defined: try to access instance with id ${(i=e.instanceId)!=null?i:""}`}));return}let a=o[e.methodName](...e.args);w(a)?(e.methodName.endsWith("ToJson")&&typeof a.result=="string"&&(a=W(a.result)),r=l(e,a)):r=l(e,{type:"error",error:a.error}),this.workerFunctions.postMessage(r);}async setup({libraryLocation:e,overrideThreadsSupport:r,overrideSimdSupport:o,verifyResponseHash:a,referredOrigin:n}){if(this.setupPromise!=null)return this.setupPromise;let{resolve:i,reject:p,promise:d}=new Deferred;this.setupPromise=d;let c=DataCaptureVersion.sdkVersion();if(c==="")throw new DataCaptureError({name:"Invalid library version",message:"Library version is not defined or empty, cannot generate proper path to library files."});let[m,g]=await Promise.all([hasSIMDSupport(),checkFullMultithreadingSupport()]);r!=="auto"&&(g=r==="on"),o!=="auto"&&(m=o==="on");let h=getLibraryLocationURIs(c,e,this.getWasmParserFileName(m,g)),{jsURI:f,wasmURI:P}=h;return this.moduleHandler.set({mainScriptUrlOrBlob:f,locateFile:u=>e+u,onMainComplete:()=>{},onRuntimeInitialized:()=>{i();},print:u=>{Logger.log(Logger.Level.Info,u);},instantiateWasm:(u,S)=>(instantiateWebAssembly({importObject:u,wasmURI:P,expectedHash:this.getWasmParserExpectedHash(m,g),verifyResponseHash:a,successCallback:S,progressCallback:()=>{},referredOrigin:n}),{})}),await importWasmScript(f,c)||p(`Couldn't retrieve Parser library at ${f}, did you configure the path for it correctly?`),d}createParser(e){var n,i;let r=this.Module.ParserInterface.create(e.args[0]);if(Logger.log(Logger.Level.Debug,`Parser:create returns ${r.type}`,r),r.type==="error")return l(e,r);let o=(i=(n=e.args[0])==null?void 0:n.toString())!=null?i:"",a=l(e,{type:"result",result:o});return this.parsers.set(o,r.result),a}getWasmParserExpectedHash(e,r){return r?e?"6fa0ff0d2888f43b9f9e2d8cfe8b54822078d25f3a16e03a58b0981769c9f465":"f3c8e4b2f876c6040508b7d04e80a8301d7cee3c02d0a8ebec2cf1e9908be6a5":e?"95af6b2a2e4d12c16808e8b111ed99d5105e8b69a105fabb52fe43fb0a758030":"b5e1473a1aeb0ef3b657fa1ece4a799fc3c8bbe683fb3c60ea1fc912736e4fa1"}getWasmParserFileName(e,r){return r?e?"scandit-datacapture-sdk-parser-simd-pthreads.wasm":"scandit-datacapture-sdk-parser-pthreads.wasm":e?"scandit-datacapture-sdk-parser-simd.wasm":"scandit-datacapture-sdk-parser.wasm"}};

export { M as a };
