import { DataCaptureContextListener, DataCaptureContext, Feedback, FrameSource } from 'scandit-web-datacapture-core';
import { SparkScanListener, SparkScan } from '../SparkScan.js';
import { SparkScanSession } from '../SparkScanSession.js';
import { SparkScanView } from './SparkScanView.js';
import { SparkScanViewHandMode } from './SparkScanViewHandMode.js';
import { SparkScanViewSettings } from './SparkScanViewSettings.js';
import 'scandit-web-datacapture-core/build/js/private/Serializable';
import '../SparkScanSettings.js';
import '../../Barcode.js';
import '../../EncodingRange.js';
import '../../StructuredAppendData.js';
import '../../ScanIntention.js';
import '../../SymbologySettings.js';
import 'scandit-web-datacapture-core/build/js/private/utils/index.js';
import '../SparkScanFeedbackDelegate.js';
import '../SparkScanBarcodeFeedback.js';
import '../SparkScanScanningMode.js';
import '../SparkScanPreviewBehavior.js';
import '../SparkScanScanningBehavior.js';
import './constants/attributes.js';
import './constants/tags.js';
import './SparkScanToastSettings.js';

declare class SparkScanViewPresenter implements SparkScanListener, DataCaptureContextListener {
    private context;
    private dataCaptureView;
    private camera?;
    private sparkScan;
    private sparkScanOverlay?;
    private sparkScanViewSettings;
    private sparkScanView;
    private feedbackManager;
    private preferenceManager;
    private stateManager;
    private triggerButtonCollapseTimeout;
    private inactiveStateTimeout;
    private resumeCapturingTimeout?;
    private scanningBehaviorCache?;
    private defaultErrorBrush;
    private constructor();
    get handMode(): SparkScanViewHandMode;
    get portraitOrientationTriggerButtonTranslateY(): number;
    get landscapeOrientationTriggerButtonTranslateY(): number;
    static forView(view: SparkScanView, context: DataCaptureContext, sparkScan: SparkScan, sparkScanViewSettings: SparkScanViewSettings): SparkScanViewPresenter;
    prepareScanning(host: HTMLElement): Promise<void>;
    startScanning(): Promise<void>;
    pauseScanning(): Promise<void>;
    stopScanning(): Promise<void>;
    onTriggerButtonTap(): Promise<void>;
    onTriggerButtonHoldStart(): Promise<void>;
    onTriggerButtonHoldEnd(): Promise<void>;
    onClickOutside(): Promise<void>;
    onVisibilityChange(): Promise<void>;
    onTargetModeButtonTap(targetModeEnabled: boolean, feedback?: Feedback, showToast?: boolean): Promise<void>;
    onScanningBehaviorButtonTap(continuousModeEnabled: boolean, feedback?: Feedback, showToast?: boolean): Promise<void>;
    onTorchButtonTap(torchEnabled: boolean, feedback?: Feedback, showToast?: boolean): Promise<void>;
    onSoundModeButtonTap(soundEnabled: boolean, feedback?: Feedback): void;
    onHapticModeButtonTap(hapticEnabled: boolean, feedback?: Feedback): void;
    onHandModeButtonTap(leftHandModeEnabled: boolean, feedback?: Feedback): void;
    onMiniPreviewResizeButtonTap(): void;
    onMiniPreviewZoomButtonTap(zoomFactor: number): Promise<void>;
    onMiniPreviewSwipeUp(): Promise<void>;
    onMiniPreviewSwipeDown(): Promise<void>;
    onTriggerButtonSwipeLeft(): Promise<void>;
    onTriggerButtonSwipeRight(): Promise<void>;
    onTriggerButtonVerticalSwipeEnd(translateY: number, orientation: OrientationType): void;
    onOrientationChange(): Promise<void>;
    didScan(_sparkScan: SparkScan, session: SparkScanSession): Promise<void>;
    didChangeFrameSource(_context: DataCaptureContext, frameSource: FrameSource | null): void;
    private switchToIdleState;
    private switchToActiveState;
    private switchToInactiveState;
    private switchToErrorState;
    private enableTargetModeLocationSelection;
    private enableTargetModeScanIntention;
    private enableTargetModeHiddenProperties;
    private enableTargetMode;
    private applyPreferences;
}

export { SparkScanViewPresenter };
