import { PrivateLoadableFrameData } from 'scandit-web-datacapture-core';
import { DataCaptureActionMessageKey as DataCaptureActionMessageKey$1, WorkerResponse as WorkerResponse$1, AnyDataCaptureActionMessage as AnyDataCaptureActionMessage$1, DataCaptureCallbackMessage as DataCaptureCallbackMessage$1, EmscriptenClassHandle, Module as Module$1, CaptureModeDeserializerInstance, JSONParseable, WasmFrameData, DataCaptureCallbackMessageKeys as DataCaptureCallbackMessageKeys$1 } from 'scandit-web-datacapture-core/build/js/worker/index';
import { BarcodeCaptureSessionJSON } from '../BarcodeCaptureSession.js';
import { BarcodeTrackingSessionJSON } from '../BarcodeTrackingSession.js';
import { TrackedBarcodeJSON } from '../TrackedBarcode.js';
import { SparkScanSessionJSON } from '../spark/SparkScanSession.js';
import '../spark/ui/SparkScanView.js';
import '../spark/ui/SparkScanViewCollapsedTriggerButton.js';
import '../spark/ui/SparkScanViewExpandedTriggerButton.js';
import '../spark/ui/SparkScanViewGestureManager.js';
import '../spark/ui/SparkScanViewIcon.js';
import '../spark/ui/SparkScanViewMiniPreview.js';
import '../spark/ui/SparkScanViewOrientationManager.js';
import '../spark/ui/SparkScanViewSidebar.js';
import '../spark/ui/SparkScanViewToast.js';
import '../spark/ui/SparkScanViewTriggerButton.js';
import '../spark/ui/SparkScanViewVisualFeedback.js';
import 'scandit-web-datacapture-core/build/js/private/Serializable';
import '../Barcode.js';
import '../EncodingRange.js';
import '../StructuredAppendData.js';
import '../LocalizedOnlyBarcode.js';
import 'scandit-web-datacapture-core/build/js/private/utils/index.js';
import '../spark/SparkScan.js';
import '../spark/SparkScanSettings.js';
import '../ScanIntention.js';
import '../SymbologySettings.js';
import '../spark/SparkScanFeedbackDelegate.js';
import '../spark/SparkScanBarcodeFeedback.js';
import '../spark/SparkScanScanningMode.js';
import '../spark/SparkScanPreviewBehavior.js';
import '../spark/SparkScanScanningBehavior.js';
import '../spark/ui/SparkScanViewSettings.js';
import '../spark/ui/SparkScanToastSettings.js';
import '../spark/ui/SparkScanViewHandMode.js';
import '../spark/ui/constants/attributes.js';
import '../spark/ui/constants/tags.js';
import '../spark/ui/constants/events.js';

/**
 * MESSAGES (ACTIONS) SENT TO THE WORKER
 */
type DataCaptureActionMessageKey = DataCaptureActionMessageKey$1 | "sparkScanEmitErrorFeedback";
type WorkerResponse<C extends DataCaptureActionMessageKey> = WorkerResponse$1<C>;
interface DataCaptureActionMessage {
    command: DataCaptureActionMessageKey;
    id: number;
}
interface SparkScanEmitErrorFeedbackDataCaptureAction extends DataCaptureActionMessage {
    command: "sparkScanEmitErrorFeedback";
    shouldRemoveBrush: boolean;
}
type AnyDataCaptureActionMessage = AnyDataCaptureActionMessage$1 | SparkScanEmitErrorFeedbackDataCaptureAction;
/**
 * MESSAGES EMITTED BY THE WORKER
 */
type DataCaptureCallbackMessageKeys = DataCaptureCallbackMessageKeys$1 | "barcodeCaptureDidScan" | "barcodeCaptureDidUpdateSession" | "barcodeTrackingDidUpdateSession" | "didTapTrackedBarcode" | "sparkScanDidScan" | "sparkScanDidUpdateSession";
interface BaseDataCaptureCallbackMessage {
    type: DataCaptureCallbackMessageKeys;
}
interface BarcodeCaptureDidScanWorkerMessage extends BaseDataCaptureCallbackMessage {
    type: "barcodeCaptureDidScan";
    payload: {
        session: BarcodeCaptureSessionJSON;
        frameData: PrivateLoadableFrameData;
    };
}
interface BarcodeCaptureDidUpdateSessionWorkerMessage extends BaseDataCaptureCallbackMessage {
    type: "barcodeCaptureDidUpdateSession";
    payload: BarcodeCaptureSessionJSON;
}
interface BarcodeTrackingDidTapTrackedBarcode extends BaseDataCaptureCallbackMessage {
    type: "didTapTrackedBarcode";
    payload: TrackedBarcodeJSON;
}
interface BarcodeTrackingDidUpdateSessionWorkerMessage extends BaseDataCaptureCallbackMessage {
    type: "barcodeTrackingDidUpdateSession";
    payload: BarcodeTrackingSessionJSON;
}
interface SparkScanDidScanWorkerMessage extends BaseDataCaptureCallbackMessage {
    type: "sparkScanDidScan";
    payload: {
        session: SparkScanSessionJSON;
        frameData: PrivateLoadableFrameData;
    };
}
interface SparkScanDidUpdateSessionWorkerMessage extends BaseDataCaptureCallbackMessage {
    type: "sparkScanDidUpdateSession";
    payload: SparkScanSessionJSON;
}
type DataCaptureCallbackMessage = BarcodeCaptureDidScanWorkerMessage | BarcodeCaptureDidUpdateSessionWorkerMessage | BarcodeTrackingDidTapTrackedBarcode | BarcodeTrackingDidUpdateSessionWorkerMessage | DataCaptureCallbackMessage$1 | SparkScanDidScanWorkerMessage | SparkScanDidUpdateSessionWorkerMessage;
/**
 * OTHERS
 */
type PayloadForCommand<A, C> = A extends {
    command: C;
} ? A : never;
interface DataCaptureWorker extends Omit<Worker, "postMessage"> {
    onmessage: ((this: Worker, event_: MessageEvent & {
        data: any;
    }) => void) | null;
    postMessage: <C extends AnyDataCaptureActionMessage["command"]>(message: PayloadForCommand<AnyDataCaptureActionMessage, C>, transfer?: Transferable[]) => void;
}
interface NativeSparkScanOverlay extends EmscriptenClassHandle<NativeSparkScanOverlay> {
    onErrorFeedbackEmitted(shouldRemoveBrush: boolean): void;
}
interface BarcodeCaptureModule extends Module$1 {
    BarcodeCaptureDeserializer: new () => CaptureModeDeserializerInstance;
    BarcodeCaptureListener: {
        extend: (target: "BarcodeCaptureListener", parameters: {
            didScan: (barcode_capture: any, session: JSONParseable, frame_data: WasmFrameData) => void;
            didUpdateSession: (barcode_capture: any, session: JSONParseable, frame_data: any) => void;
        }) => new () => EmscriptenClassHandle;
    };
    BarcodeCaptureDeserializerListener: {
        extend: (target: "BarcodeCaptureDeserializerListener", parameters: {
            onModeDeserializationStarted: (deserializer: any, mode: any, json: JSONParseable) => void;
            onModeDeserializationFinished: (deserializer: any, mode: any, json: JSONParseable) => void;
            onSettingsDeserializationStarted: (deserializer: any, settings: any, json: JSONParseable) => void;
            onSettingsDeserializationFinished: (deserializer: any, settings: any, json: JSONParseable) => void;
        }) => new () => EmscriptenClassHandle;
    };
    BarcodeTrackingDeserializer: new () => CaptureModeDeserializerInstance;
    BarcodeTrackingListener: {
        extend: (target: "BarcodeTrackingListener", parameters: {
            didUpdateSession: (barcode_tracking: any, session: JSONParseable, frame_data: any) => void;
            onTrackedBarcodeTapped: (barcode_tracking: any, tracked_barcode: JSONParseable) => void;
        }) => new () => EmscriptenClassHandle;
    };
    BarcodeTrackingDeserializerListener: {
        extend: (target: "BarcodeTrackingDeserializerListener", parameters: {
            onModeDeserializationStarted: (deserializer: any, mode: any, json: JSONParseable) => void;
            onModeDeserializationFinished: (deserializer: any, mode: any, json: JSONParseable) => void;
            onSettingsDeserializationStarted: (deserializer: any, settings: any, json: JSONParseable) => void;
            onSettingsDeserializationFinished: (deserializer: any, settings: any, json: JSONParseable) => void;
        }) => new () => EmscriptenClassHandle;
    };
    SparkScanDeserializer: new () => CaptureModeDeserializerInstance;
    SparkScanListener: {
        extend: (target: "SparkScanListener", parameters: {
            didScan: (spark_scan: any, session: JSONParseable, frame_data: WasmFrameData) => void;
            didUpdateSession: (spark_scan: any, session: JSONParseable, frame_data: any) => void;
        }) => new () => EmscriptenClassHandle;
    };
    SparkScanDeserializerListener: {
        extend: (target: "SparkScanDeserializerListener", parameters: {
            onModeDeserializationStarted: (deserializer: any, mode: any, json: JSONParseable) => void;
            onModeDeserializationFinished: (deserializer: any, mode: any, json: JSONParseable) => void;
            onSettingsDeserializationStarted: (deserializer: any, settings: any, json: JSONParseable) => void;
            onSettingsDeserializationFinished: (deserializer: any, settings: any, json: JSONParseable) => void;
            onOverlayDeserializationStarted: (deserializer: any, overlay: NativeSparkScanOverlay, json: JSONParseable) => void;
            onOverlayDeserializationFinished: (deserializer: any, overlay: NativeSparkScanOverlay, json: JSONParseable) => void;
        }) => new () => EmscriptenClassHandle;
    };
    LicenseUtils: {
        getBlinkIdLicenseKey: (scanditLicense: string) => string;
    };
}
interface Module extends Module$1, BarcodeCaptureModule {
}
type EngineWorkerResponse<C extends DataCaptureActionMessageKey> = WorkerResponse<C> extends Promise<void> | void ? Promise<void> | void : {
    payload: WorkerResponse<C>;
    transferables?: Transferable[];
};

export type { AnyDataCaptureActionMessage, BarcodeCaptureDidScanWorkerMessage, BarcodeCaptureDidUpdateSessionWorkerMessage, BarcodeCaptureModule, BarcodeTrackingDidTapTrackedBarcode, DataCaptureActionMessageKey, DataCaptureCallbackMessage, DataCaptureWorker, EngineWorkerResponse, Module, NativeSparkScanOverlay, PayloadForCommand, SparkScanDidScanWorkerMessage, SparkScanDidUpdateSessionWorkerMessage, SparkScanEmitErrorFeedbackDataCaptureAction, WorkerResponse };
