/*
Copyright (c) 2019 Daybrush
name: @scena/react-ruler
license: MIT
author: Daybrush
repository: https://github.com/daybrush/ruler/blob/master/packages/react-ruler
version: 0.8.1
*/
'use strict';

var React = require('react');
var frameworkUtils = require('framework-utils');
var utils = require('@daybrush/utils');

/*! *****************************************************************************
Copyright (c) Microsoft Corporation. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this file except in compliance with the License. You may obtain a copy of the
License at http://www.apache.org/licenses/LICENSE-2.0

THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
MERCHANTABLITY OR NON-INFRINGEMENT.

See the Apache Version 2.0 License for specific language governing permissions
and limitations under the License.
***************************************************************************** */

/* global Reflect, Promise */
var extendStatics = function (d, b) {
  extendStatics = Object.setPrototypeOf || {
    __proto__: []
  } instanceof Array && function (d, b) {
    d.__proto__ = b;
  } || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
  };

  return extendStatics(d, b);
};

function __extends(d, b) {
  extendStatics(d, b);

  function __() {
    this.constructor = d;
  }

  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var Ruler =
/*#__PURE__*/
function (_super) {
  __extends(Ruler, _super);

  function Ruler() {
    var _this = _super !== null && _super.apply(this, arguments) || this;

    _this.state = {
      scrollPos: 0
    };
    _this.width = 0;
    _this.height = 0;
    return _this;
  }

  var __proto = Ruler.prototype;

  __proto.render = function () {
    return React.createElement("canvas", {
      ref: frameworkUtils.ref(this, "canvasElement"),
      style: this.props.style
    });
  };

  __proto.componentDidMount = function () {
    var canvas = this.canvasElement;
    var context = canvas.getContext("2d");
    this.canvasContext = context;
    this.resize();
  };

  __proto.componentDidUpdate = function () {
    this.resize();
  };
  /**
   * @method Ruler#scroll
   * @param scrollPos
   */


  __proto.scroll = function (scrollPos) {
    this.draw(scrollPos);
  };
  /**
   * @method Ruler#resize
   */


  __proto.resize = function () {
    var canvas = this.canvasElement;
    var _a = this.props,
        width = _a.width,
        height = _a.height,
        scrollPos = _a.scrollPos;
    this.width = width || canvas.offsetWidth;
    this.height = height || canvas.offsetHeight;
    canvas.width = this.width * 2;
    canvas.height = this.height * 2;
    this.draw(scrollPos);
  };

  __proto.draw = function (scrollPos) {
    if (scrollPos === void 0) {
      scrollPos = this.state.scrollPos;
    }

    var props = this.props;
    var _a = props,
        unit = _a.unit,
        zoom = _a.zoom,
        type = _a.type,
        backgroundColor = _a.backgroundColor,
        lineColor = _a.lineColor,
        textColor = _a.textColor,
        direction = _a.direction,
        _b = _a.negativeRuler,
        negativeRuler = _b === void 0 ? true : _b,
        _c = _a.segment,
        segment = _c === void 0 ? 10 : _c,
        textFormat = _a.textFormat;
    var width = this.width;
    var height = this.height;
    var state = this.state;
    state.scrollPos = scrollPos;
    var context = this.canvasContext;
    var isHorizontal = type === "horizontal";
    var isDirectionStart = direction === "start";
    var isNegative = negativeRuler !== false;
    var font = props.font || "10px sans-serif";
    var textAlign = props.textAlign || "left";
    var textOffset = props.textOffset || [0, 0];
    var containerSize = isHorizontal ? height : width;
    var mainLineSize = utils.convertUnitSize("" + (props.mainLineSize || "100%"), containerSize);
    var longLineSize = utils.convertUnitSize("" + (props.longLineSize || 10), containerSize);
    var shortLineSize = utils.convertUnitSize("" + (props.shortLineSize || 7), containerSize);

    if (backgroundColor === "transparent") {
      // Clear existing paths & text
      context.clearRect(0, 0, width * 2, height * 2);
    } else {
      // Draw the background
      context.rect(0, 0, width * 2, height * 2);
      context.fillStyle = backgroundColor;
      context.fill();
    }

    context.save();
    context.scale(2, 2);
    context.strokeStyle = lineColor;
    context.lineWidth = 1;
    context.font = font;
    context.fillStyle = textColor;

    if (isDirectionStart) {
      context.textBaseline = "top";
    }

    context.translate(0.5, 0);
    context.beginPath();
    var size = isHorizontal ? width : height;
    var zoomUnit = zoom * unit;
    var minRange = Math.floor(scrollPos * zoom / zoomUnit);
    var maxRange = Math.ceil((scrollPos * zoom + size) / zoomUnit);
    var length = maxRange - minRange;
    var alignOffset = Math.max(["left", "center", "right"].indexOf(textAlign) - 1, -1);

    for (var i = 0; i <= length; ++i) {
      var value = i + minRange;

      if (!isNegative && value < 0) {
        continue;
      }

      var startPos = (value * unit - scrollPos) * zoom;

      for (var j = 0; j < segment; ++j) {
        var pos = startPos + j / segment * zoomUnit;

        if (pos < 0 || pos >= size) {
          continue;
        }

        var lineSize = j === 0 ? mainLineSize : j % 2 === 0 ? longLineSize : shortLineSize;

        var _d = isHorizontal ? [pos, isDirectionStart ? 0 : height - lineSize] : [isDirectionStart ? 0 : width - lineSize, pos],
            x1 = _d[0],
            y1 = _d[1];

        var _e = isHorizontal ? [x1, y1 + lineSize] : [x1 + lineSize, y1],
            x2 = _e[0],
            y2 = _e[1];

        context.moveTo(x1, y1);
        context.lineTo(x2, y2);
      }

      if (startPos >= -zoomUnit && startPos < size + unit * zoom) {
        var _f = isHorizontal ? [startPos + alignOffset * -3, isDirectionStart ? 17 : height - 17] : [isDirectionStart ? 17 : width - 17, startPos + alignOffset * 3],
            startX = _f[0],
            startY = _f[1];

        var text = "" + value * unit;

        if (textFormat) {
          text = textFormat(value * unit);
        }

        context.textAlign = textAlign;

        if (isHorizontal) {
          context.fillText(text, startX + textOffset[0], startY + textOffset[1]);
        } else {
          context.save();
          context.translate(startX + textOffset[0], startY + textOffset[1]);
          context.rotate(-Math.PI / 2);
          context.fillText(text, 0, 0);
          context.restore();
        }
      }
    }

    context.stroke();
    context.restore();
  };

  Ruler.defaultProps = {
    type: "horizontal",
    zoom: 1,
    width: 0,
    height: 0,
    unit: 50,
    negativeRuler: true,
    mainLineSize: "100%",
    longLineSize: 10,
    shortLineSize: 7,
    segment: 10,
    direction: "end",
    style: {
      width: "100%",
      height: "100%"
    },
    backgroundColor: "#333333",
    font: "10px sans-serif",
    textColor: "#ffffff",
    lineColor: "#777777"
  };
  return Ruler;
}(React.PureComponent);

var PROPERTIES = ["type", "width", "height", "unit", "zoom", "style", "backgroundColor", "lineColor", "textColor", "direction", "textFormat", "scrollPos", "textAlign", "mainLineSize", "longLineSize", "shortLineSize", "negativeRuler", "textOffset", "font", "segment"];
var METHODS = ["scroll", "resize"];



var others = ({
    'default': Ruler,
    PROPERTIES: PROPERTIES,
    METHODS: METHODS
});

for (var name in others) {
  Ruler[name] = others[name];
}

module.exports = Ruler;
//# sourceMappingURL=ruler.cjs.js.map
