"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const schematics_1 = require("@angular-devkit/schematics");
function getWorkspacePath(host) {
    const possibleFiles = ['/angular.json', '/.angular.json'];
    const path = possibleFiles.filter(path => host.exists(path))[0];
    return path;
}
exports.getWorkspacePath = getWorkspacePath;
function getWorkspace(host) {
    const path = getWorkspacePath(host);
    const configBuffer = host.read(path);
    if (configBuffer === null) {
        throw new schematics_1.SchematicsException(`Could not find (${path})`);
    }
    const config = configBuffer.toString();
    return JSON.parse(config);
}
exports.getWorkspace = getWorkspace;
function addProjectToWorkspace(workspace, name, project) {
    return (host, context) => {
        if (workspace.projects[name]) {
            throw new Error(`Project '${name}' already exists in workspace.`);
        }
        // Add project to workspace.
        workspace.projects[name] = project;
        if (!workspace.defaultProject && Object.keys(workspace.projects).length === 1) {
            // Make the new project the default one.
            workspace.defaultProject = name;
        }
        host.overwrite(getWorkspacePath(host), JSON.stringify(workspace, null, 2));
    };
}
exports.addProjectToWorkspace = addProjectToWorkspace;
exports.configPath = '/.angular-cli.json';
function getConfig(host) {
    const configBuffer = host.read(exports.configPath);
    if (configBuffer === null) {
        throw new schematics_1.SchematicsException('Could not find .angular-cli.json');
    }
    const config = JSON.parse(configBuffer.toString());
    return config;
}
exports.getConfig = getConfig;
function getAppFromConfig(config, appIndexOrName) {
    if (!config.apps) {
        return null;
    }
    if (parseInt(appIndexOrName) >= 0) {
        return config.apps[parseInt(appIndexOrName)];
    }
    return config.apps.filter((app) => app.name === appIndexOrName)[0];
}
exports.getAppFromConfig = getAppFromConfig;
//# sourceMappingURL=data:application/json;base64,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