export interface Schema {
    /**
     * Whether to update all packages in package.json.
     */
    all?: boolean;
    /**
     * If false, will error out if installed packages are incompatible with the update.
     */
    force?: boolean;
    /**
     * Version from which to migrate from. Only available with a single package being updated,
     * and only on migration only.
     */
    from?: string;
    /**
     * Only perform a migration, does not update the installed version.
     */
    migrateOnly?: boolean;
    /**
     * Use the largest version, including beta and RCs.
     */
    next?: boolean;
    /**
     * The preferred package manager configuration files to use for registry settings.
     */
    packageManager?: PackageManager;
    /**
     * The names of package(s) to update.
     */
    packages?: string[];
    /**
     * The NPM registry to use.
     */
    registry?: string;
    /**
     * Version up to which to apply migrations. Only available with a single package being
     * updated, and only on migrations only. Requires from to be specified. Default to the
     * installed version detected.
     */
    to?: string;
    /**
     * Display additional details during the update process.
     */
    verbose?: boolean;
}
/**
 * The preferred package manager configuration files to use for registry settings.
 */
export declare enum PackageManager {
    Npm = "npm",
    Yarn = "yarn"
}
