"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const schematics_1 = require("@angular-devkit/schematics");
const semver = require("semver");
function default_1(options) {
    return (tree, context) => {
        const schematicsToRun = [];
        // Create the collection for the package.
        const collection = context.engine.createCollection(options.collection);
        for (const name of collection.listSchematicNames()) {
            const schematic = collection.createSchematic(name, true);
            const description = schematic.description;
            if (typeof description['version'] == 'string') {
                let version = description['version'];
                if (!version.match(/^\d{1,30}\.\d{1,30}\.\d{1,30}$/)) {
                    version += '.0';
                }
                if (!version.match(/^\d{1,30}\.\d{1,30}\.\d{1,30}$/)) {
                    version += '.0';
                }
                if (!semver.valid(version)) {
                    throw new schematics_1.SchematicsException(`Invalid migration version: ${JSON.stringify(description['version'])}`);
                }
                if (semver.gt(version, options.from) && semver.lte(version, options.to)) {
                    schematicsToRun.push({ name, version });
                }
            }
        }
        schematicsToRun.sort((a, b) => {
            const cmp = semver.compare(a.version, b.version);
            // Revert to comparing the names of the collection if the versions are equal.
            return cmp == 0 ? a.name.localeCompare(b.name) : cmp;
        });
        if (schematicsToRun.length > 0) {
            const rules = schematicsToRun.map(x => schematics_1.externalSchematic(options.collection, x.name, {}));
            return schematics_1.chain(rules)(tree, context);
        }
        return tree;
    };
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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