"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const schematics_1 = require("@angular-devkit/schematics");
const semver = require("semver");
/**
 * Cleans up "short" version numbers so they become valid semver. For example;
 *   1 => 1.0.0
 *   1.2 => 1.2.0
 *   1-beta => 1.0.0-beta
 *
 * Exported for testing only.
 * @internal
 */
function _coerceVersionNumber(version) {
    if (!version.match(/^\d{1,30}\.\d{1,30}\.\d{1,30}/)) {
        const match = version.match(/^\d{1,30}(\.\d{1,30})*/);
        if (!match) {
            return null;
        }
        if (!match[1]) {
            version = version.substr(0, match[0].length) + '.0.0' + version.substr(match[0].length);
        }
        else if (!match[2]) {
            version = version.substr(0, match[0].length) + '.0' + version.substr(match[0].length);
        }
        else {
            return null;
        }
    }
    return semver.valid(version);
}
exports._coerceVersionNumber = _coerceVersionNumber;
function default_1(options) {
    return (tree, context) => {
        const schematicsToRun = [];
        // Create the collection for the package.
        const collection = context.engine.createCollection(options.collection);
        for (const name of collection.listSchematicNames()) {
            const schematic = collection.createSchematic(name, true);
            const description = schematic.description;
            let version = description['version'];
            if (typeof version == 'string') {
                version = _coerceVersionNumber(version);
                if (!version) {
                    throw new schematics_1.SchematicsException(`Invalid migration version: ${JSON.stringify(description['version'])}`);
                }
                if (semver.gt(version, options.from) && semver.lte(version, options.to)) {
                    schematicsToRun.push({ name, version });
                }
            }
        }
        schematicsToRun.sort((a, b) => {
            const cmp = semver.compare(a.version, b.version);
            // Revert to comparing the names of the collection if the versions are equal.
            return cmp == 0 ? a.name.localeCompare(b.name) : cmp;
        });
        if (schematicsToRun.length > 0) {
            const rules = schematicsToRun.map(x => schematics_1.externalSchematic(options.collection, x.name, {}));
            return schematics_1.chain(rules);
        }
        return tree;
    };
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiLi8iLCJzb3VyY2VzIjpbInBhY2thZ2VzL3NjaGVtYXRpY3MvdXBkYXRlL21pZ3JhdGUvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFRQSwyREFPb0M7QUFDcEMsaUNBQWlDO0FBSWpDOzs7Ozs7OztHQVFHO0FBQ0gsOEJBQXFDLE9BQWU7SUFDbEQsSUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsK0JBQStCLENBQUMsRUFBRTtRQUNuRCxNQUFNLEtBQUssR0FBRyxPQUFPLENBQUMsS0FBSyxDQUFDLHdCQUF3QixDQUFDLENBQUM7UUFFdEQsSUFBSSxDQUFDLEtBQUssRUFBRTtZQUNWLE9BQU8sSUFBSSxDQUFDO1NBQ2I7UUFFRCxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxFQUFFO1lBQ2IsT0FBTyxHQUFHLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQyxFQUFFLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxNQUFNLENBQUMsR0FBRyxNQUFNLEdBQUcsT0FBTyxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUM7U0FDekY7YUFBTSxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxFQUFFO1lBQ3BCLE9BQU8sR0FBRyxPQUFPLENBQUMsTUFBTSxDQUFDLENBQUMsRUFBRSxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUMsTUFBTSxDQUFDLEdBQUcsSUFBSSxHQUFHLE9BQU8sQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDO1NBQ3ZGO2FBQU07WUFDTCxPQUFPLElBQUksQ0FBQztTQUNiO0tBQ0Y7SUFFRCxPQUFPLE1BQU0sQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUM7QUFDL0IsQ0FBQztBQWxCRCxvREFrQkM7QUFHRCxtQkFBd0IsT0FBeUI7SUFDL0MsT0FBTyxDQUFDLElBQVUsRUFBRSxPQUF5QixFQUFFLEVBQUU7UUFDL0MsTUFBTSxlQUFlLEdBQXlDLEVBQUUsQ0FBQztRQUVqRSx5Q0FBeUM7UUFDekMsTUFBTSxVQUFVLEdBQUcsT0FBTyxDQUFDLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDLENBQUM7UUFDdkUsS0FBSyxNQUFNLElBQUksSUFBSSxVQUFVLENBQUMsa0JBQWtCLEVBQUUsRUFBRTtZQUNsRCxNQUFNLFNBQVMsR0FBRyxVQUFVLENBQUMsZUFBZSxDQUFDLElBQUksRUFBRSxJQUFJLENBQUMsQ0FBQztZQUV6RCxNQUFNLFdBQVcsR0FBZSxTQUFTLENBQUMsV0FBeUIsQ0FBQztZQUNwRSxJQUFJLE9BQU8sR0FBRyxXQUFXLENBQUMsU0FBUyxDQUFDLENBQUM7WUFFckMsSUFBSSxPQUFPLE9BQU8sSUFBSSxRQUFRLEVBQUU7Z0JBQzlCLE9BQU8sR0FBRyxvQkFBb0IsQ0FBQyxPQUFPLENBQUMsQ0FBQztnQkFFeEMsSUFBSSxDQUFDLE9BQU8sRUFBRTtvQkFDWixNQUFNLElBQUksZ0NBQW1CLENBQzNCLDhCQUE4QixJQUFJLENBQUMsU0FBUyxDQUFDLFdBQVcsQ0FBQyxTQUFTLENBQUMsQ0FBQyxFQUFFLENBQ3ZFLENBQUM7aUJBQ0g7Z0JBRUQsSUFBSSxNQUFNLENBQUMsRUFBRSxDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsSUFBSSxDQUFDLElBQUksTUFBTSxDQUFDLEdBQUcsQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLEVBQUUsQ0FBQyxFQUFFO29CQUN2RSxlQUFlLENBQUMsSUFBSSxDQUFDLEVBQUUsSUFBSSxFQUFFLE9BQU8sRUFBRSxDQUFDLENBQUM7aUJBQ3pDO2FBQ0Y7U0FDRjtRQUVELGVBQWUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUU7WUFDNUIsTUFBTSxHQUFHLEdBQUcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsT0FBTyxFQUFFLENBQUMsQ0FBQyxPQUFPLENBQUMsQ0FBQztZQUVqRCw2RUFBNkU7WUFDN0UsT0FBTyxHQUFHLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLEdBQUcsQ0FBQztRQUN2RCxDQUFDLENBQUMsQ0FBQztRQUVILElBQUksZUFBZSxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUU7WUFDOUIsTUFBTSxLQUFLLEdBQUcsZUFBZSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLDhCQUFpQixDQUFDLE9BQU8sQ0FBQyxVQUFVLEVBQUUsQ0FBQyxDQUFDLElBQUksRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDO1lBRTFGLE9BQU8sa0JBQUssQ0FBQyxLQUFLLENBQUMsQ0FBQztTQUNyQjtRQUVELE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQyxDQUFDO0FBQ0osQ0FBQztBQTFDRCw0QkEwQ0MiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEBsaWNlbnNlXG4gKiBDb3B5cmlnaHQgR29vZ2xlIEluYy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2FuZ3VsYXIuaW8vbGljZW5zZVxuICovXG5pbXBvcnQgeyBKc29uT2JqZWN0IH0gZnJvbSAnQGFuZ3VsYXItZGV2a2l0L2NvcmUnO1xuaW1wb3J0IHtcbiAgUnVsZSxcbiAgU2NoZW1hdGljQ29udGV4dCxcbiAgU2NoZW1hdGljc0V4Y2VwdGlvbixcbiAgVHJlZSxcbiAgY2hhaW4sXG4gIGV4dGVybmFsU2NoZW1hdGljLFxufSBmcm9tICdAYW5ndWxhci1kZXZraXQvc2NoZW1hdGljcyc7XG5pbXBvcnQgKiBhcyBzZW12ZXIgZnJvbSAnc2VtdmVyJztcbmltcG9ydCB7IFBvc3RVcGRhdGVTY2hlbWEgfSBmcm9tICcuL3NjaGVtYSc7XG5cblxuLyoqXG4gKiBDbGVhbnMgdXAgXCJzaG9ydFwiIHZlcnNpb24gbnVtYmVycyBzbyB0aGV5IGJlY29tZSB2YWxpZCBzZW12ZXIuIEZvciBleGFtcGxlO1xuICogICAxID0+IDEuMC4wXG4gKiAgIDEuMiA9PiAxLjIuMFxuICogICAxLWJldGEgPT4gMS4wLjAtYmV0YVxuICpcbiAqIEV4cG9ydGVkIGZvciB0ZXN0aW5nIG9ubHkuXG4gKiBAaW50ZXJuYWxcbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIF9jb2VyY2VWZXJzaW9uTnVtYmVyKHZlcnNpb246IHN0cmluZyk6IHN0cmluZyB8IG51bGwge1xuICBpZiAoIXZlcnNpb24ubWF0Y2goL15cXGR7MSwzMH1cXC5cXGR7MSwzMH1cXC5cXGR7MSwzMH0vKSkge1xuICAgIGNvbnN0IG1hdGNoID0gdmVyc2lvbi5tYXRjaCgvXlxcZHsxLDMwfShcXC5cXGR7MSwzMH0pKi8pO1xuXG4gICAgaWYgKCFtYXRjaCkge1xuICAgICAgcmV0dXJuIG51bGw7XG4gICAgfVxuXG4gICAgaWYgKCFtYXRjaFsxXSkge1xuICAgICAgdmVyc2lvbiA9IHZlcnNpb24uc3Vic3RyKDAsIG1hdGNoWzBdLmxlbmd0aCkgKyAnLjAuMCcgKyB2ZXJzaW9uLnN1YnN0cihtYXRjaFswXS5sZW5ndGgpO1xuICAgIH0gZWxzZSBpZiAoIW1hdGNoWzJdKSB7XG4gICAgICB2ZXJzaW9uID0gdmVyc2lvbi5zdWJzdHIoMCwgbWF0Y2hbMF0ubGVuZ3RoKSArICcuMCcgKyB2ZXJzaW9uLnN1YnN0cihtYXRjaFswXS5sZW5ndGgpO1xuICAgIH0gZWxzZSB7XG4gICAgICByZXR1cm4gbnVsbDtcbiAgICB9XG4gIH1cblxuICByZXR1cm4gc2VtdmVyLnZhbGlkKHZlcnNpb24pO1xufVxuXG5cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uKG9wdGlvbnM6IFBvc3RVcGRhdGVTY2hlbWEpOiBSdWxlIHtcbiAgcmV0dXJuICh0cmVlOiBUcmVlLCBjb250ZXh0OiBTY2hlbWF0aWNDb250ZXh0KSA9PiB7XG4gICAgY29uc3Qgc2NoZW1hdGljc1RvUnVuOiB7IG5hbWU6IHN0cmluZzsgdmVyc2lvbjogc3RyaW5nOyB9W10gPSBbXTtcblxuICAgIC8vIENyZWF0ZSB0aGUgY29sbGVjdGlvbiBmb3IgdGhlIHBhY2thZ2UuXG4gICAgY29uc3QgY29sbGVjdGlvbiA9IGNvbnRleHQuZW5naW5lLmNyZWF0ZUNvbGxlY3Rpb24ob3B0aW9ucy5jb2xsZWN0aW9uKTtcbiAgICBmb3IgKGNvbnN0IG5hbWUgb2YgY29sbGVjdGlvbi5saXN0U2NoZW1hdGljTmFtZXMoKSkge1xuICAgICAgY29uc3Qgc2NoZW1hdGljID0gY29sbGVjdGlvbi5jcmVhdGVTY2hlbWF0aWMobmFtZSwgdHJ1ZSk7XG5cbiAgICAgIGNvbnN0IGRlc2NyaXB0aW9uOiBKc29uT2JqZWN0ID0gc2NoZW1hdGljLmRlc2NyaXB0aW9uIGFzIEpzb25PYmplY3Q7XG4gICAgICBsZXQgdmVyc2lvbiA9IGRlc2NyaXB0aW9uWyd2ZXJzaW9uJ107XG5cbiAgICAgIGlmICh0eXBlb2YgdmVyc2lvbiA9PSAnc3RyaW5nJykge1xuICAgICAgICB2ZXJzaW9uID0gX2NvZXJjZVZlcnNpb25OdW1iZXIodmVyc2lvbik7XG5cbiAgICAgICAgaWYgKCF2ZXJzaW9uKSB7XG4gICAgICAgICAgdGhyb3cgbmV3IFNjaGVtYXRpY3NFeGNlcHRpb24oXG4gICAgICAgICAgICBgSW52YWxpZCBtaWdyYXRpb24gdmVyc2lvbjogJHtKU09OLnN0cmluZ2lmeShkZXNjcmlwdGlvblsndmVyc2lvbiddKX1gLFxuICAgICAgICAgICk7XG4gICAgICAgIH1cblxuICAgICAgICBpZiAoc2VtdmVyLmd0KHZlcnNpb24sIG9wdGlvbnMuZnJvbSkgJiYgc2VtdmVyLmx0ZSh2ZXJzaW9uLCBvcHRpb25zLnRvKSkge1xuICAgICAgICAgIHNjaGVtYXRpY3NUb1J1bi5wdXNoKHsgbmFtZSwgdmVyc2lvbiB9KTtcbiAgICAgICAgfVxuICAgICAgfVxuICAgIH1cblxuICAgIHNjaGVtYXRpY3NUb1J1bi5zb3J0KChhLCBiKSA9PiB7XG4gICAgICBjb25zdCBjbXAgPSBzZW12ZXIuY29tcGFyZShhLnZlcnNpb24sIGIudmVyc2lvbik7XG5cbiAgICAgIC8vIFJldmVydCB0byBjb21wYXJpbmcgdGhlIG5hbWVzIG9mIHRoZSBjb2xsZWN0aW9uIGlmIHRoZSB2ZXJzaW9ucyBhcmUgZXF1YWwuXG4gICAgICByZXR1cm4gY21wID09IDAgPyBhLm5hbWUubG9jYWxlQ29tcGFyZShiLm5hbWUpIDogY21wO1xuICAgIH0pO1xuXG4gICAgaWYgKHNjaGVtYXRpY3NUb1J1bi5sZW5ndGggPiAwKSB7XG4gICAgICBjb25zdCBydWxlcyA9IHNjaGVtYXRpY3NUb1J1bi5tYXAoeCA9PiBleHRlcm5hbFNjaGVtYXRpYyhvcHRpb25zLmNvbGxlY3Rpb24sIHgubmFtZSwge30pKTtcblxuICAgICAgcmV0dXJuIGNoYWluKHJ1bGVzKTtcbiAgICB9XG5cbiAgICByZXR1cm4gdHJlZTtcbiAgfTtcbn1cbiJdfQ==