'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.spring = undefined;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj; };

exports.getMotionStyle = getMotionStyle;
exports.valueFromPercents = valueFromPercents;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactMotion = require('react-motion');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Need component to pass into react-docgen
 */
var AnimationProps = function AnimationProps() {
    return _react2.default.createElement('noscript', null);
};

/**
 * Returns animation style for Motion
 * @param initialAnimation Initial animation configuration
 * @param enterAnimation Enter animation configuration
 * @param leaveAnimation Leave animation configuration
 * @param active True if we're entering, false if we're leaving
 */
function getMotionStyle(initialAnimation, enterAnimation, leaveAnimation, active) {
    if (active) {
        // Start animation is disabled, return initialAnimation
        // enterAnimation=true will also disable it
        if (typeof enterAnimation === "boolean") {
            return initialAnimation;
        } else {
            var _ret = function () {
                var animationStyle = {};
                Object.keys(enterAnimation).forEach(function (key) {
                    animationStyle[key] = typeof enterAnimation[key] === "number" ? (0, _reactMotion.spring)(enterAnimation[key]) : enterAnimation[key];
                });
                return {
                    v: animationStyle
                };
            }();

            if ((typeof _ret === 'undefined' ? 'undefined' : _typeof(_ret)) === "object") return _ret.v;
        }
    } else {
        // Leave animation is disabled
        if (typeof leaveAnimation === "boolean") {
            // Hide object immediately
            return {
                opacity: 0
            };
        } else {
            var _ret2 = function () {
                var animationStyle = {};
                Object.keys(leaveAnimation).forEach(function (key) {
                    animationStyle[key] = typeof leaveAnimation[key] === "number" ? (0, _reactMotion.spring)(leaveAnimation[key]) : leaveAnimation[key];
                });
                return {
                    v: animationStyle
                };
            }();

            if ((typeof _ret2 === 'undefined' ? 'undefined' : _typeof(_ret2)) === "object") return _ret2.v;
        }
    }
}

/**
 * Return real value from percent value. Useful for animating height in onAnimationStyle()
 * @param percentValue
 * @param total
 * @returns {number}
 */
function valueFromPercents(percentValue, total) {
    return total / 100 * percentValue;
}

// re-export spring for convenience
exports.spring = _reactMotion.spring;
exports.default = AnimationProps;
//# sourceMappingURL=animationUtils.js.map