'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactAddonsShallowCompare = require('react-addons-shallow-compare');

var _reactAddonsShallowCompare2 = _interopRequireDefault(_reactAddonsShallowCompare);

var _utilities = require('../../utilities');

var _defaultProps = require('../../defaultProps');

var _defaultProps2 = _interopRequireDefault(_defaultProps);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var validProps = {
    aligned: ['right', 'left', 'justified', 'center'],
    floated: ['right', 'left'],
    valigned: ['top', 'middle', 'bottom']

};

/**
 * Grid column
 */
var Column = (_temp = _class = function (_React$Component) {
    _inherits(Column, _React$Component);

    function Column() {
        _classCallCheck(this, Column);

        return _possibleConstructorReturn(this, Object.getPrototypeOf(Column).apply(this, arguments));
    }

    _createClass(Column, [{
        key: 'shouldComponentUpdate',
        value: function shouldComponentUpdate(nextProps, nextState) {
            return (0, _reactAddonsShallowCompare2.default)(this, nextProps, nextState);
        }
    }, {
        key: 'render',
        value: function render() {
            /* eslint-disable no-use-before-define */
            var _props = this.props;
            var aligned = _props.aligned;
            var component = _props.component;
            var children = _props.children;
            var defaultClasses = _props.defaultClasses;
            var floated = _props.floated;
            var only = _props.only;
            var color = _props.color;
            var width = _props.width;
            var mobileWidth = _props.mobileWidth;
            var tabletWidth = _props.tabletWidth;
            var computerWidth = _props.computerWidth;
            var largeScreenWidth = _props.largeScreenWidth;
            var wideScreenWidth = _props.wideScreenWidth;
            var valigned = _props.valigned;

            var other = _objectWithoutProperties(_props, ['aligned', 'component', 'children', 'defaultClasses', 'floated', 'only', 'color', 'width', 'mobileWidth', 'tabletWidth', 'computerWidth', 'largeScreenWidth', 'wideScreenWidth', 'valigned']);
            /* eslint-enable no-use-before-define */


            var Component = component;
            other.className = (0, _classnames2.default)(other.className, this.getClasses());

            return _react2.default.createElement(
                Component,
                other,
                children
            );
        }
    }, {
        key: 'getClasses',
        value: function getClasses() {
            var classes = {
                column: this.props.defaultClasses
            };

            classes[this.props.color] = !!this.props.color;

            // Widths
            if (this.props.width && this.props.width > 0 && this.props.width <= 16) {
                classes[_utilities.Numbers[this.props.width] + ' wide'] = true;
            }

            if (this.props.mobileWidth && this.props.mobileWidth > 0 && this.props.mobileWidth <= 16) {
                classes[_utilities.Numbers[this.props.mobileWidth] + ' wide mobile'] = true;
            }

            if (this.props.tabletWidth && this.props.tabletWidth > 0 && this.props.tabletWidth <= 16) {
                classes[_utilities.Numbers[this.props.tabletWidth] + ' wide tablet'] = true;
            }

            if (this.props.computerWidth && this.props.computerWidth > 0 && this.props.computerWidth <= 16) {
                classes[_utilities.Numbers[this.props.computerWidth] + ' wide computer'] = true;
            }

            if (this.props.largeScreenWidth && this.props.largeScreenWidth > 0 && this.props.largeScreenWidth <= 16) {
                classes[_utilities.Numbers[this.props.largeScreenWidth] + ' wide large screen'] = true;
            }

            if (this.props.wideScreenWidth && this.props.wideScreenWidth > 0 && this.props.wideScreenWidth <= 16) {
                classes[_utilities.Numbers[this.props.wideScreenWidth] + ' wide widescreen'] = true;
            }

            if (this.props.only) {
                var device = void 0;
                if (Array.isArray(this.props.only)) {
                    device = this.props.only.join(' ');
                } else {
                    device = this.props.only;
                }
                if (device) {
                    classes[device + ' only'] = true;
                }
            }

            return (0, _utilities.validateClassProps)(classes, this.props, validProps, { valigned: 'aligned' });
        }
    }]);

    return Column;
}(_react2.default.Component), _class.defaultProps = _extends({}, _defaultProps2.default.defaultProps), _temp);
exports.default = Column;
//# sourceMappingURL=column.js.map