'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactAddonsShallowCompare = require('react-addons-shallow-compare');

var _reactAddonsShallowCompare2 = _interopRequireDefault(_reactAddonsShallowCompare);

var _utilities = require('../../utilities');

var _defaultProps = require('../../defaultProps');

var _defaultProps2 = _interopRequireDefault(_defaultProps);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var validProps = {
    aligned: ['right', 'left', 'center'],
    celled: ['internally'],
    divided: ['vertically', 'internally'],
    padded: ['horizontally', 'vertically'],
    relaxed: ['very'],
    reversed: ['mobile', 'mobile vertically', 'tablet', 'tablet vertically', 'computer', 'computer vertically'],
    valigned: ['top', 'middle', 'bottom']
};

/**
 * Semantic Grid
 */
var Grid = (_temp = _class = function (_React$Component) {
    _inherits(Grid, _React$Component);

    function Grid() {
        _classCallCheck(this, Grid);

        return _possibleConstructorReturn(this, Object.getPrototypeOf(Grid).apply(this, arguments));
    }

    _createClass(Grid, [{
        key: 'shouldComponentUpdate',
        value: function shouldComponentUpdate(nextProps, nextState) {
            return (0, _reactAddonsShallowCompare2.default)(this, nextProps, nextState);
        }
    }, {
        key: 'render',
        value: function render() {
            // consume props
            /* eslint-disable no-use-before-define */
            var _props = this.props;
            var aligned = _props.aligned;
            var defaultClasses = _props.defaultClasses;
            var centered = _props.centered;
            var celled = _props.celled;
            var columns = _props.columns;
            var container = _props.container;
            var component = _props.component;
            var children = _props.children;
            var divided = _props.divided;
            var doubling = _props.doubling;
            var equal = _props.equal;
            var padded = _props.padded;
            var relaxed = _props.relaxed;
            var reversed = _props.reversed;
            var stackable = _props.stackable;
            var valigned = _props.valigned;

            var other = _objectWithoutProperties(_props, ['aligned', 'defaultClasses', 'centered', 'celled', 'columns', 'container', 'component', 'children', 'divided', 'doubling', 'equal', 'padded', 'relaxed', 'reversed', 'stackable', 'valigned']);
            /* eslint-enable no-use-before-define */


            var Component = component;
            other.className = (0, _classnames2.default)(other.className, this.getClassNames());
            return _react2.default.createElement(
                Component,
                other,
                children
            );
        }
    }, {
        key: 'getClassNames',
        value: function getClassNames() {
            var classes = {
                // Default
                ui: this.props.defaultClasses,
                grid: this.props.defaultClasses,

                // variations
                container: this.props.container,
                relaxed: this.props.relaxed,
                centered: this.props.centered,
                stackable: this.props.stackable,
                doubling: this.props.doubling
            };

            if (this.props.columns && this.props.columns > 0 && this.props.columns <= 16) {
                classes[_utilities.Numbers[this.props.columns] + ' column'] = true;
            }

            if (this.props.equal) {
                classes['equal width'] = true;
            }

            return (0, _utilities.validateClassProps)(classes, this.props, validProps, { valigned: 'aligned' });
        }
    }]);

    return Grid;
}(_react2.default.Component), _class.defaultProps = _extends({}, _defaultProps2.default.defaultProps), _temp);
exports.default = Grid;
//# sourceMappingURL=grid.js.map