'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactAddonsShallowCompare = require('react-addons-shallow-compare');

var _reactAddonsShallowCompare2 = _interopRequireDefault(_reactAddonsShallowCompare);

var _utilities = require('../../utilities');

var _defaultProps = require('../../defaultProps');

var _defaultProps2 = _interopRequireDefault(_defaultProps);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var validProps = {
    aligned: ['right', 'left', 'center'],
    valigned: ['top', 'middle', 'bottom']
};

/**
 * Grid row
 */
var Row = (_temp = _class = function (_React$Component) {
    _inherits(Row, _React$Component);

    function Row() {
        _classCallCheck(this, Row);

        return _possibleConstructorReturn(this, Object.getPrototypeOf(Row).apply(this, arguments));
    }

    _createClass(Row, [{
        key: 'shouldComponentUpdate',
        value: function shouldComponentUpdate(nextProps, nextState) {
            return (0, _reactAddonsShallowCompare2.default)(this, nextProps, nextState);
        }
    }, {
        key: 'render',
        value: function render() {
            /* eslint-disable no-use-before-define */
            var _props = this.props;
            var aligned = _props.aligned;
            var component = _props.component;
            var centered = _props.centered;
            var children = _props.children;
            var columns = _props.columns;
            var defaultClasses = _props.defaultClasses;
            var doubling = _props.doubling;
            var equal = _props.equal;
            var stretched = _props.stretched;
            var color = _props.color;
            var only = _props.only;
            var justified = _props.justified;
            var valigned = _props.valigned;

            var other = _objectWithoutProperties(_props, ['aligned', 'component', 'centered', 'children', 'columns', 'defaultClasses', 'doubling', 'equal', 'stretched', 'color', 'only', 'justified', 'valigned']);
            /* eslint-enable no-use-before-define */

            var Component = component;
            other.className = (0, _classnames2.default)(other.className, this.getClasses());

            return _react2.default.createElement(
                Component,
                other,
                children
            );
        }
    }, {
        key: 'getClasses',
        value: function getClasses() {
            var classes = {
                row: this.props.defaultClasses,
                centered: this.props.centered,
                doubling: this.props.doubling,
                stretched: this.props.stretched,
                justified: this.props.justified
            };

            if (this.props.columns && this.props.columns > 0 && this.props.columns <= 16) {
                classes[_utilities.Numbers[this.props.columns] + ' column'] = true;
            }

            classes[this.props.color] = !!this.props.color;

            if (this.props.equal) {
                classes['equal width'] = true;
            }

            if (this.props.only) {
                var device = void 0;
                if (Array.isArray(this.props.only)) {
                    device = this.props.only.join(' ');
                } else {
                    device = this.props.only;
                }
                if (device) {
                    classes[device + ' only'] = true;
                }
            }

            return (0, _utilities.validateClassProps)(classes, this.props, validProps, { valigned: 'aligned' });
        }
    }]);

    return Row;
}(_react2.default.Component), _class.defaultProps = _extends({}, _defaultProps2.default.defaultProps), _temp);
exports.default = Row;
//# sourceMappingURL=row.js.map