'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactAddonsShallowCompare = require('react-addons-shallow-compare');

var _reactAddonsShallowCompare2 = _interopRequireDefault(_reactAddonsShallowCompare);

var _utilities = require('../../utilities');

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _defaultProps = require('../../defaultProps');

var _defaultProps2 = _interopRequireDefault(_defaultProps);

var _icon = require('../../elements/icon/icon');

var _icon2 = _interopRequireDefault(_icon);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var validProps = {
    attached: ['bottom', 'top'],
    emphasis: ['success', 'error', 'info', 'warning', 'positive', 'negative']
};

var Message = (_temp = _class = function (_React$Component) {
    _inherits(Message, _React$Component);

    function Message() {
        _classCallCheck(this, Message);

        return _possibleConstructorReturn(this, Object.getPrototypeOf(Message).apply(this, arguments));
    }

    _createClass(Message, [{
        key: 'shouldComponentUpdate',

        /* eslint-enable */

        value: function shouldComponentUpdate(nextProps, nextState) {
            return (0, _reactAddonsShallowCompare2.default)(this, nextProps, nextState);
        }

        /* eslint-disable */

    }, {
        key: 'render',
        value: function render() {
            /* eslint-disable no-use-before-define */
            var _props = this.props;
            var attached = _props.attached;
            var children = _props.children;
            var className = _props.className;
            var color = _props.color;
            var compact = _props.compact;
            var component = _props.component;
            var defaultClasses = _props.defaultClasses;
            var floating = _props.floating;
            var hidden = _props.hidden;
            var icon = _props.icon;
            var size = _props.size;
            var emphasis = _props.emphasis;
            var visible = _props.visible;

            var other = _objectWithoutProperties(_props, ['attached', 'children', 'className', 'color', 'compact', 'component', 'defaultClasses', 'floating', 'hidden', 'icon', 'size', 'emphasis', 'visible']);
            /* eslint-enable no-use-before-define */

            other.className = (0, _classnames2.default)(className, this.getClasses());

            return _react2.default.createElement(component, other, children);
        }
    }, {
        key: 'getClasses',
        value: function getClasses() {
            var classes = {
                ui: this.props.defaultClasses,

                compact: this.props.compact,
                floating: this.props.floating,
                hidden: this.props.hidden,
                // Do not set icon flag automatically if it explicitly provided even with icon child
                icon: this.props.icon || (0, _utilities.hasFirstChild)(this.props.children, Message.Components.Icon) && typeof this.props.icon === 'undefined',
                visible: this.props.visible,

                info: this.props.emphasis === 'info',
                warning: this.props.emphasis === 'warning',
                positive: this.props.emphasis === 'positive',
                negative: this.props.emphasis === 'negative',

                success: this.props.emphasis === 'success',
                error: this.props.emphasis === 'error',

                message: this.props.defaultClasses
            };

            classes[this.props.color] = !!this.props.color;
            classes[this.props.size] = !!this.props.size;
            return (0, _utilities.validateClassProps)(classes, this.props, validProps);
        }
    }]);

    return Message;
}(_react2.default.Component), _class.defaultProps = _extends({}, _defaultProps2.default.defaultProps), _class.Components = {
    Icon: _icon2.default
}, _temp);
exports.default = Message;
//# sourceMappingURL=message.js.map