'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactAddonsShallowCompare = require('react-addons-shallow-compare');

var _reactAddonsShallowCompare2 = _interopRequireDefault(_reactAddonsShallowCompare);

var _utilities = require('../../utilities');

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _defaultProps = require('../../defaultProps');

var _defaultProps2 = _interopRequireDefault(_defaultProps);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var validProps = {
    aligned: ['top', 'bottom'],
    basic: ['very'],
    padded: ['very'],
    valigned: ['center', 'right']
};

var Table = (_temp = _class = function (_React$Component) {
    _inherits(Table, _React$Component);

    function Table() {
        _classCallCheck(this, Table);

        return _possibleConstructorReturn(this, Object.getPrototypeOf(Table).apply(this, arguments));
    }

    _createClass(Table, [{
        key: 'shouldComponentUpdate',
        value: function shouldComponentUpdate(nextProps, nextState) {
            return (0, _reactAddonsShallowCompare2.default)(this, nextProps, nextState);
        }
    }, {
        key: 'render',
        value: function render() {
            /* eslint-disable no-use-before-define */
            var _props = this.props;
            var aligned = _props.aligned;
            var basic = _props.basic;
            var celled = _props.celled;
            var children = _props.children;
            var className = _props.className;
            var collapsing = _props.collapsing;
            var compact = _props.compact;
            var color = _props.color;
            var component = _props.component;
            var defaultClasses = _props.defaultClasses;
            var columns = _props.columns;
            var definition = _props.definition;
            var fixed = _props.fixed;
            var inverted = _props.inverted;
            var padded = _props.padded;
            var selectable = _props.selectable;
            var singleLine = _props.singleLine;
            var size = _props.size;
            var sortable = _props.sortable;
            var stackable = _props.stackable;
            var striped = _props.striped;
            var structured = _props.structured;
            var unstackable = _props.unstackable;
            var valigned = _props.valigned;
            var width = _props.width;

            var other = _objectWithoutProperties(_props, ['aligned', 'basic', 'celled', 'children', 'className', 'collapsing', 'compact', 'color', 'component', 'defaultClasses', 'columns', 'definition', 'fixed', 'inverted', 'padded', 'selectable', 'singleLine', 'size', 'sortable', 'stackable', 'striped', 'structured', 'unstackable', 'valigned', 'width']);
            /* eslint-enable no-use-before-define */

            other.className = (0, _classnames2.default)(className, this.getClasses(), this.mobileFormat('stackable', stackable), this.mobileFormat('unstackable', unstackable));

            return _react2.default.createElement(component, other, children);
        }
    }, {
        key: 'getClasses',
        value: function getClasses() {
            var classes = {
                ui: this.props.defaultClasses,

                basic: this.props.basic,
                collapsing: this.props.collapsing,
                compact: this.props.compact,
                celled: this.props.celled,
                definition: this.props.definition,
                fixed: this.props.fixed,
                inverted: this.props.inverted,
                selectable: this.props.selectable,
                'single line': this.props.singleLine,
                sortable: this.props.sortable,
                striped: this.props.striped,
                structured: this.props.structured,

                table: this.props.defaultClasses
            };

            classes[this.props.color] = !!this.props.color;
            classes[this.props.size] = !!this.props.size;

            if (this.props.columns !== false) {
                if (this.props.columns > 0 && this.props.columns <= 16) {
                    classes[_utilities.Numbers[this.props.columns] + ' column'] = true;
                }
            }

            if (this.props.width !== false) {
                if (this.props.width > 0 && this.props.width <= 16) {
                    classes[_utilities.Numbers[this.props.width] + ' wide'] = true;
                }
            }

            return (0, _utilities.validateClassProps)(classes, this.props, validProps, { valigned: 'aligned' });
        }
    }, {
        key: 'mobileFormat',
        value: function mobileFormat(name, options) {
            var classes = {};

            Object.keys(options).forEach(function (value) {
                if (options[value]) classes[value + ' ' + name] = true;
            });

            // all of the options are true?
            return classes;
        }
    }]);

    return Table;
}(_react2.default.Component), _class.defaultProps = _extends({}, _defaultProps2.default.defaultProps, {
    component: 'table',
    stackable: {
        computer: false,
        mobile: false,
        tablet: false
    },
    unstackable: {
        computer: false,
        mobile: false,
        tablet: false
    }
}), _temp);
exports.default = Table;
//# sourceMappingURL=table.js.map