'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactAddonsShallowCompare = require('react-addons-shallow-compare');

var _reactAddonsShallowCompare2 = _interopRequireDefault(_reactAddonsShallowCompare);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _utilities = require('../../utilities');

var _defaultProps = require('./../../defaultProps');

var _defaultProps2 = _interopRequireDefault(_defaultProps);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var validProps = {
    animated: ['vertical', 'fade'],
    attached: ['left', 'right', 'bottom', 'top'],
    floated: ['left', 'right']
};

/**
 * Basic button. Icon and labeled buttons have own components
 */
var Button = (_temp = _class = function (_React$Component) {
    _inherits(Button, _React$Component);

    function Button() {
        _classCallCheck(this, Button);

        return _possibleConstructorReturn(this, Object.getPrototypeOf(Button).apply(this, arguments));
    }

    _createClass(Button, [{
        key: 'shouldComponentUpdate',
        value: function shouldComponentUpdate(nextProps, nextState) {
            return (0, _reactAddonsShallowCompare2.default)(this, nextProps, nextState);
        }
    }, {
        key: 'render',
        value: function render() {
            // consume this.props
            var _props = this.props;
            var animated = _props.animated;
            var attached = _props.attached;
            var basic = _props.basic;
            var children = _props.children;
            var circular = _props.circular;
            var color = _props.color;
            var component = _props.component;
            var compact = _props.compact;
            var defaultClasses = _props.defaultClasses;
            var emphasis = _props.emphasis;
            var floated = _props.floated;
            var fluid = _props.fluid;
            var inverted = _props.inverted;
            var size = _props.size;
            var state = _props.state;
            var toggle = _props.toggle;

            var other = _objectWithoutProperties(_props, ['animated', 'attached', 'basic', 'children', 'circular', 'color', 'component', 'compact', 'defaultClasses', 'emphasis', 'floated', 'fluid', 'inverted', 'size', 'state', 'toggle']);

            var Component = attached || this.context.isAttached || animated || _react2.default.Children.count(this.props.children) > 1 ? 'div' : 'button';
            if (component) {
                Component = component;
            }

            other.className = (0, _classnames2.default)(other.className, this.getClasses());

            return _react2.default.createElement(
                Component,
                other,
                children
            );
        }
    }, {
        key: 'getClasses',
        value: function getClasses() {
            var classes = {
                // default
                ui: this.props.defaultClasses,

                // position based this.props
                floated: this.props.floated,
                attached: this.props.attached,

                // types
                animated: this.props.animated,
                basic: this.props.basic,
                inverted: this.props.inverted,

                // variations
                circular: this.props.circular,
                compact: this.props.compact,
                fluid: this.props.fluid,

                // component
                button: this.props.defaultClasses
            };

            // string types
            classes[this.props.color] = !!this.props.color;
            classes[this.props.size] = !!this.props.size;
            classes[this.props.social] = !!this.props.social;
            classes[this.props.emphasis] = !!this.props.emphasis;
            classes[this.props.state] = !!this.props.state;

            return (0, _utilities.validateClassProps)(classes, this.props, validProps);
        }
    }]);

    return Button;
}(_react2.default.Component), _class.contextTypes = {
    isAttached: _react2.default.PropTypes.bool
}, _class.defaultProps = {
    defaultClasses: true
}, _temp);
exports.default = Button;
//# sourceMappingURL=button.js.map