'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactAddonsShallowCompare = require('react-addons-shallow-compare');

var _reactAddonsShallowCompare2 = _interopRequireDefault(_reactAddonsShallowCompare);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _elementType = require('react-prop-types/lib/elementType');

var _elementType2 = _interopRequireDefault(_elementType);

var _icon = require('./../icon/icon');

var _icon2 = _interopRequireDefault(_icon);

var _label = require('./../label/label');

var _label2 = _interopRequireDefault(_label);

var _button = require('./button');

var _button2 = _interopRequireDefault(_button);

var _utilities = require('../../utilities');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var validProps = {
    labeled: ['left', 'right']
};

/**
 * Labeled button renders button with label, either text label or icon
 */
var LabeledButton = (_temp = _class = function (_React$Component) {
    _inherits(LabeledButton, _React$Component);

    function LabeledButton() {
        _classCallCheck(this, LabeledButton);

        return _possibleConstructorReturn(this, Object.getPrototypeOf(LabeledButton).apply(this, arguments));
    }

    _createClass(LabeledButton, [{
        key: 'shouldComponentUpdate',

        /* eslint-enable */

        value: function shouldComponentUpdate(nextProps, nextState) {
            return (0, _reactAddonsShallowCompare2.default)(this, nextProps, nextState);
        }

        /* eslint-disable */

    }, {
        key: 'render',
        value: function render() {
            var _props = this.props;
            var children = _props.children;
            var labeled = _props.labeled;
            var labelType = _props.labelType;
            var label = _props.label;
            var labelComponent = _props.labelComponent;

            var other = _objectWithoutProperties(_props, ['children', 'labeled', 'labelType', 'label', 'labelComponent']);

            var LabelComponent = labelComponent ? labelComponent : this.getDefaultLabelComponent(labelType);

            if (labelType === 'icon') {
                // Easy markup, it's the standard button with labeled icon prefix, the icon order doesn't matter
                other.className = (0, _classnames2.default)(other.className, this.getClasses());
                return _react2.default.createElement(
                    LabeledButton.Components.Button,
                    other,
                    _react2.default.createElement(LabelComponent, { name: label }),
                    children
                );
            } else {
                // Text labeled button, this is slightly harder, label order does matter, also need to be prefixed with <div>
                var className = (0, _classnames2.default)(this.getClasses());
                var markup = [];
                /* eslint-disable react/jsx-max-props-per-line */
                // Should be label basic by default?
                if (labeled === 'left') {
                    markup.push(_react2.default.createElement(
                        LabelComponent,
                        { basic: true, key: 'label' },
                        label
                    ));
                    markup.push(_react2.default.createElement(
                        LabeledButton.Components.Button,
                        _extends({ key: 'button' }, other),
                        children
                    ));
                } else {
                    markup.push(_react2.default.createElement(
                        LabeledButton.Components.Button,
                        _extends({ key: 'button' }, other),
                        children
                    ));
                    markup.push(_react2.default.createElement(
                        LabelComponent,
                        { basic: true, key: 'label' },
                        label
                    ));
                }
                /* eslint-enable react/jsx-max-props-per-line */
                // TODO: Should allow to customize this div??
                return _react2.default.createElement(
                    'div',
                    { className: className },
                    markup
                );
            }
        }

        /**
         * Returns default component for label
         * @param {string} type
         */

    }, {
        key: 'getDefaultLabelComponent',
        value: function getDefaultLabelComponent(type) {
            return type === 'icon' ? LabeledButton.Components.Icon : LabeledButton.Components.Label; // eslint-disable-line
        }

        /**
         * Returns class name
         */

    }, {
        key: 'getClasses',
        value: function getClasses() {
            var classes = {
                ui: this.props.labelType !== 'icon', // no need to add ui since <Button> will add it
                icon: this.props.labelType === 'icon',
                button: this.props.labelType !== 'icon'
            };
            return (0, _utilities.validateClassProps)(classes, this.props, validProps);
        }
    }]);

    return LabeledButton;
}(_react2.default.Component), _class.defaultProps = {
    labeled: 'right',
    labelType: 'text'
}, _class.Components = {
    Icon: _icon2.default,
    Label: _label2.default,
    Button: _button2.default
}, _temp);
exports.default = LabeledButton;
//# sourceMappingURL=labeledbutton.js.map