'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactAddonsShallowCompare = require('react-addons-shallow-compare');

var _reactAddonsShallowCompare2 = _interopRequireDefault(_reactAddonsShallowCompare);

var _elementType = require('react-prop-types/lib/elementType');

var _elementType2 = _interopRequireDefault(_elementType);

var _utilities = require('../../utilities');

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _defaultProps = require('../../defaultProps');

var _defaultProps2 = _interopRequireDefault(_defaultProps);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var validProps = {
    aligned: ['top', 'middle', 'bottom'],
    floated: ['right', 'left'],
    spaced: ['right', 'left']
};

/**
 * Just an image
 */
var Image = (_temp = _class = function (_React$Component) {
    _inherits(Image, _React$Component);

    function Image() {
        _classCallCheck(this, Image);

        return _possibleConstructorReturn(this, Object.getPrototypeOf(Image).apply(this, arguments));
    }

    _createClass(Image, [{
        key: 'shouldComponentUpdate',
        value: function shouldComponentUpdate(nextProps, nextState) {
            return (0, _reactAddonsShallowCompare2.default)(this, nextProps, nextState);
        }
    }, {
        key: 'render',
        value: function render() {
            var _props = this.props;
            var component = _props.component;
            var children = _props.children;
            var defaultClasses = _props.defaultClasses;
            var aligned = _props.aligned;
            var avatar = _props.avatar;
            var bordered = _props.bordered;
            var centered = _props.centered;
            var fluid = _props.fluid;
            var floated = _props.floated;
            var size = _props.size;
            var spaced = _props.spaced;
            var src = _props.src;
            var state = _props.state;
            var shape = _props.shape;
            var wrapComponent = _props.wrapComponent;

            var other = _objectWithoutProperties(_props, ['component', 'children', 'defaultClasses', 'aligned', 'avatar', 'bordered', 'centered', 'fluid', 'floated', 'size', 'spaced', 'src', 'state', 'shape', 'wrapComponent']);

            other.className = (0, _classnames2.default)(other.className, this.getClasses());
            var ImageComponent = component;
            if (this.shouldWrapIntoDiv() || wrapComponent) {
                var WrapComponent = typeof wrapComponent === 'undefined' || typeof wrapComponent === 'boolean' ? 'div' : wrapComponent;
                return _react2.default.createElement(
                    WrapComponent,
                    other,
                    children,
                    _react2.default.createElement(ImageComponent, { src: src })
                );
            } else {
                return _react2.default.createElement(ImageComponent, _extends({}, other, { src: src }));
            }
        }
    }, {
        key: 'getClasses',
        value: function getClasses() {
            var classes = {
                // Do not set ui class if image is items child, but set anyway is items child and should has size prop
                ui: this.props.defaultClasses && (!this.context.isItemsChild || this.context.isItemsChild && this.props.size),
                image: this.props.defaultClasses,

                // variations
                aligned: this.props.aligned,
                avatar: this.props.avatar,
                bordered: this.props.bordered,
                centered: this.props.centered,
                circular: this.props.shape === 'circular',
                floated: this.props.floated,
                fluid: this.props.fluid,
                rounded: this.props.shape === 'rounded',
                spaced: this.props.spaced
            };

            classes[this.props.state] = !!this.props.state;
            classes[this.props.size] = !!this.props.size;

            return (0, _utilities.validateClassProps)(classes, this.props, validProps);
        }

        /**
         * Return true if image should be forced wrapped into div
         * @returns {boolean}
         */

    }, {
        key: 'shouldWrapIntoDiv',
        value: function shouldWrapIntoDiv() {
            return this.context.isCommentsChild || this.context.isItemsChild || _react2.default.Children.count(this.props.children) > 0;
        }
    }]);

    return Image;
}(_react2.default.Component), _class.contextTypes = {
    isCommentsChild: _react2.default.PropTypes.bool, // Image in Comment should be wrapper into <div/>
    isItemsChild: _react2.default.PropTypes.bool // Image in Items should be wrapped into <div/>
}, _class.defaultProps = _extends({}, _defaultProps2.default.defaultProps, {
    component: 'img',
    wrapComponent: false
}), _temp);
exports.default = Image;
//# sourceMappingURL=image.js.map