'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactAddonsShallowCompare = require('react-addons-shallow-compare');

var _reactAddonsShallowCompare2 = _interopRequireDefault(_reactAddonsShallowCompare);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _elementType = require('react-prop-types/lib/elementType');

var _elementType2 = _interopRequireDefault(_elementType);

var _defaultProps = require('../../defaultProps');

var _defaultProps2 = _interopRequireDefault(_defaultProps);

var _icon = require('./../icon/icon');

var _icon2 = _interopRequireDefault(_icon);

var _label = require('./../label/label');

var _label2 = _interopRequireDefault(_label);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * Controlled basic input
 */
var Input = (_temp = _class = function (_React$Component) {
  _inherits(Input, _React$Component);

  function Input() {
    _classCallCheck(this, Input);

    return _possibleConstructorReturn(this, Object.getPrototypeOf(Input).apply(this, arguments));
  }

  _createClass(Input, [{
    key: 'shouldComponentUpdate',

    /* eslint-enable */

    value: function shouldComponentUpdate(nextProps, nextState) {
      return (0, _reactAddonsShallowCompare2.default)(this, nextProps, nextState);
    }

    /* eslint-disable */

  }, {
    key: 'render',
    value: function render() {
      var _props = this.props;
      var component = _props.component;
      var children = _props.children;
      var className = _props.className;
      var defaultClasses = _props.defaultClasses;
      var style = _props.style;
      var actionComponent = _props.actionComponent;
      var actionPosition = _props.actionPosition;
      var fluid = _props.fluid;
      var icon = _props.icon;
      var iconPosition = _props.iconPosition;
      var iconComponent = _props.iconComponent;
      var inverted = _props.inverted;
      var label = _props.label;
      var labelComponent = _props.labelComponent;
      var labelPosition = _props.labelPosition;
      var placeholder = _props.placeholder;
      var size = _props.size;
      var state = _props.state;
      var transparent = _props.transparent;
      var value = _props.value;

      var other = _objectWithoutProperties(_props, ['component', 'children', 'className', 'defaultClasses', 'style', 'actionComponent', 'actionPosition', 'fluid', 'icon', 'iconPosition', 'iconComponent', 'inverted', 'label', 'labelComponent', 'labelPosition', 'placeholder', 'size', 'state', 'transparent', 'value']);

      var wrapperClassName = (0, _classnames2.default)(className, this.getClasses());
      var InputComponent = component;
      var IconComponent = iconComponent || Input.Components.Icon;
      var LabelComponent = labelComponent || Input.Components.Label;
      var ActionComponent = actionComponent;

      return _react2.default.createElement(
        'div',
        { className: wrapperClassName, style: style },
        actionComponent && actionPosition === 'left' && _react2.default.createElement(ActionComponent, null),
        label && (labelPosition === 'left' || labelPosition === 'left corner') && _react2.default.createElement(
          LabelComponent,
          { corner: labelPosition === 'left corner' ? 'left' : null },
          label
        ),
        _react2.default.createElement(InputComponent, _extends({ type: 'text' }, other, { value: value, placeholder: placeholder })),
        state && state === 'loading' ? _react2.default.createElement(_icon2.default, { name: 'search' }) : icon && _react2.default.createElement(IconComponent, { name: icon }),
        label && (labelPosition === 'right' || labelPosition === 'right corner') && _react2.default.createElement(
          LabelComponent,
          { corner: labelPosition === 'right corner' ? 'right' : null },
          label
        ),
        actionComponent && actionPosition === 'right' && _react2.default.createElement(ActionComponent, null),
        children
      );
    }
  }, {
    key: 'getClasses',
    value: function getClasses() {
      var classes = {
        ui: this.props.defaultClasses,
        input: this.props.defaultClasses,

        fluid: this.props.fluid,
        inverted: this.props.inverted,
        transparent: this.props.transparent
      };
      classes[this.props.size] = !!this.props.size;
      // Loading state should add icon
      if (this.props.state && this.props.state === 'loading') {
        classes['icon'] = true;
      }
      classes[this.props.state] = !!this.props.state;

      // action input
      if (this.props.actionComponent) {
        classes[this.props.actionPosition] = true;
        classes['action'] = true;
      }
      // Icon input
      if (this.props.icon) {
        classes[this.props.iconPosition] = true;
        classes['icon'] = true;
      }
      // Labeled input
      if (this.props.label) {
        classes[this.props.labelPosition] = true;
        classes['labeled'] = true;
      }
      return classes;
    }
  }]);

  return Input;
}(_react2.default.Component), _class.defaultProps = _extends({}, _defaultProps2.default.defaultProps, {
  component: 'input',
  iconPosition: 'right',
  labelPosition: 'left',
  actionPosition: 'right'
}), _class.Components = {
  Icon: _icon2.default,
  Label: _label2.default
}, _temp);
exports.default = Input;
//# sourceMappingURL=input.js.map