'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactAddonsShallowCompare = require('react-addons-shallow-compare');

var _reactAddonsShallowCompare2 = _interopRequireDefault(_reactAddonsShallowCompare);

var _utilities = require('../../utilities');

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _defaultProps = require('../../defaultProps');

var _defaultProps2 = _interopRequireDefault(_defaultProps);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var validProps = {
    attached: ['top', 'bottom', 'top right', 'top left', 'bottom left', 'bottom right'],
    corner: ['left', 'right'],
    pointing: ['top', 'bottom', 'left', 'right'],
    ribbon: ['right']
};

/**
 * Label
 */
var Label = (_temp = _class = function (_React$Component) {
    _inherits(Label, _React$Component);

    function Label() {
        _classCallCheck(this, Label);

        return _possibleConstructorReturn(this, Object.getPrototypeOf(Label).apply(this, arguments));
    }

    _createClass(Label, [{
        key: 'shouldComponentUpdate',
        value: function shouldComponentUpdate(nextProps, nextState) {
            return (0, _reactAddonsShallowCompare2.default)(this, nextProps, nextState);
        }
    }, {
        key: 'render',
        value: function render() {
            var _props = this.props;
            var component = _props.component;
            var children = _props.children;
            var defaultClasses = _props.defaultClasses;
            var attached = _props.attached;
            var basic = _props.basic;
            var circular = _props.circular;
            var color = _props.color;
            var corner = _props.corner;
            var empty = _props.empty;
            var floating = _props.floating;
            var horizontal = _props.horizontal;
            var image = _props.image;
            var link = _props.link;
            var pointing = _props.pointing;
            var ribbon = _props.ribbon;
            var size = _props.size;
            var tag = _props.tag;

            var other = _objectWithoutProperties(_props, ['component', 'children', 'defaultClasses', 'attached', 'basic', 'circular', 'color', 'corner', 'empty', 'floating', 'horizontal', 'image', 'link', 'pointing', 'ribbon', 'size', 'tag']);

            var Component = this.getComponent();

            other.className = (0, _classnames2.default)(other.className, this.getClasses());
            return _react2.default.createElement(
                Component,
                other,
                image && _react2.default.createElement('img', { src: image }),
                children
            );
        }
    }, {
        key: 'getClasses',
        value: function getClasses() {
            var classes = {
                // default
                ui: this.props.defaultClasses && !this.context.isCardsChild && !this.context.isProgressChild && !this.context.isStatisticChild,

                // types
                attached: this.props.attached,
                corner: this.props.corner,
                floating: this.props.floating,
                image: this.props.image,
                pointing: this.props.pointing,
                ribbon: this.props.ribbon,
                tag: this.props.tag,
                basic: this.props.basic,
                horizontal: this.props.horizontal,

                // variations
                circular: this.props.circular,
                empty: this.props.empty,

                // component
                label: this.props.defaultClasses
            };

            // handle mixed string/bool this.props
            classes[this.props.color] = !!this.props.color;
            classes[this.props.size] = !!this.props.size;

            return (0, _utilities.validateClassProps)(classes, this.props, validProps);
        }
    }, {
        key: 'getComponent',
        value: function getComponent() {
            return (this.props.link || this.props.onClick) && this.props.component === 'div' ? 'a' : this.props.component;
        }
    }]);

    return Label;
}(_react2.default.Component), _class.contextTypes = {
    isCardsChild: _react2.default.PropTypes.bool,
    isProgressChild: _react2.default.PropTypes.bool,
    isStatisticChild: _react2.default.PropTypes.bool
}, _class.defaultProps = _extends({}, _defaultProps2.default.defaultProps), _temp);
exports.default = Label;
//# sourceMappingURL=label.js.map