'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactAddonsShallowCompare = require('react-addons-shallow-compare');

var _reactAddonsShallowCompare2 = _interopRequireDefault(_reactAddonsShallowCompare);

var _elementType = require('react-prop-types/lib/elementType');

var _elementType2 = _interopRequireDefault(_elementType);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _icon = require('../icon/icon');

var _icon2 = _interopRequireDefault(_icon);

var _image = require('../image/image');

var _image2 = _interopRequireDefault(_image);

var _content = require('../simple/content');

var _content2 = _interopRequireDefault(_content);

var _list = require('./list');

var _list2 = _interopRequireDefault(_list);

var _defaultProps = require('../../defaultProps');

var _defaultProps2 = _interopRequireDefault(_defaultProps);

var _utilities = require('../../utilities');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var ListItem = (_temp = _class = function (_React$Component) {
    _inherits(ListItem, _React$Component);

    function ListItem() {
        _classCallCheck(this, ListItem);

        return _possibleConstructorReturn(this, Object.getPrototypeOf(ListItem).apply(this, arguments));
    }

    _createClass(ListItem, [{
        key: 'shouldComponentUpdate',

        /* eslint-enable */

        value: function shouldComponentUpdate(nextProps, nextState) {
            return (0, _reactAddonsShallowCompare2.default)(nextProps, nextState);
        }

        /* eslint-disable */

    }, {
        key: 'renderImageComponent',
        value: function renderImageComponent() {
            var _props = this.props;
            var image = _props.image;
            var imageType = _props.imageType;
            var imageComponent = _props.imageComponent;

            if (!image) {
                return null;
            }
            var ImageComponent = imageComponent ? imageComponent : imageType === 'icon' ? ListItem.Components.Icon : ListItem.Components.Image;
            // Looks like avatar image is most common used in list case
            var imageProps = imageType === 'icon' ? { name: image } : { avatar: true, src: image };
            return _react2.default.createElement(ImageComponent, imageProps);
        }
    }, {
        key: 'renderRightFloatedComponent',
        value: function renderRightFloatedComponent() {
            var rightFloatedComponent = this.props.rightFloatedComponent;

            if (!rightFloatedComponent) {
                return null;
            }
            var RightFloatedComponent = rightFloatedComponent;
            return _react2.default.createElement(
                ListItem.Components.Content,
                { floated: 'right' },
                _react2.default.createElement(RightFloatedComponent, null)
            );
        }
    }, {
        key: 'renderContent',
        value: function renderContent() {
            var _props2 = this.props;
            var children = _props2.children;
            var contentAligned = _props2.contentAligned;
            // Do not render content if has another sublist

            if ((0, _utilities.hasChild)(children, ListItem.Components.List)) {
                return children;
            } else {
                return _react2.default.createElement(
                    ListItem.Components.Content,
                    { aligned: contentAligned },
                    children
                );
            }
        }
    }, {
        key: 'render',
        value: function render() {
            var _props3 = this.props;
            var component = _props3.component;
            var children = _props3.children;
            var defaultClasses = _props3.defaultClasses;
            var active = _props3.active;
            var contentAligned = _props3.contentAligned;
            var image = _props3.image;
            var imageType = _props3.imageType;
            var imageComponent = _props3.imageComponent;
            var rightFloatedComponent = _props3.rightFloatedComponent;

            var other = _objectWithoutProperties(_props3, ['component', 'children', 'defaultClasses', 'active', 'contentAligned', 'image', 'imageType', 'imageComponent', 'rightFloatedComponent']);
            // List items should use <a>


            var Component = this.context.isLinkList ? 'a' : component;

            other.className = (0, _classnames2.default)(other.className, this.getClasses());
            return _react2.default.createElement(
                Component,
                other,
                this.renderRightFloatedComponent(),
                this.renderImageComponent(),
                this.renderContent()
            );
        }
    }, {
        key: 'getClasses',
        value: function getClasses() {
            return {
                active: this.props.active && this.context.isLinkList,
                link: this.context.isLinkList,
                item: this.props.defaultClasses
            };
        }
    }]);

    return ListItem;
}(_react2.default.Component), _class.contextTypes = {
    isLinkList: _react2.default.PropTypes.bool
}, _class.defaultProps = _extends({}, _defaultProps2.default.defaultProps, {
    imageType: 'icon'
}), _class.Components = {
    Content: _content2.default,
    Icon: _icon2.default,
    Image: _image2.default,
    List: _list2.default
}, _temp);
exports.default = ListItem;
//# sourceMappingURL=listitem.js.map