'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactAddonsShallowCompare = require('react-addons-shallow-compare');

var _reactAddonsShallowCompare2 = _interopRequireDefault(_reactAddonsShallowCompare);

var _utilities = require('../../utilities');

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _defaultProps = require('../../defaultProps');

var _defaultProps2 = _interopRequireDefault(_defaultProps);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var validProps = {
  aligned: ['right', 'left', 'center'],
  attached: ['bottom', 'top'],
  floated: ['right', 'left']
};

var Segment = (_temp = _class = function (_React$Component) {
  _inherits(Segment, _React$Component);

  function Segment() {
    _classCallCheck(this, Segment);

    return _possibleConstructorReturn(this, Object.getPrototypeOf(Segment).apply(this, arguments));
  }

  _createClass(Segment, [{
    key: 'shouldComponentUpdate',
    value: function shouldComponentUpdate(nextProps, nextState) {
      return (0, _reactAddonsShallowCompare2.default)(this, nextProps, nextState);
    }
  }, {
    key: 'render',
    value: function render() {
      /* eslint-disable no-use-before-define */
      var _props = this.props;
      var component = _props.component;
      var defaultClasses = _props.defaultClasses;
      var children = _props.children;
      var aligned = _props.aligned;
      var attached = _props.attached;
      var basic = _props.basic;
      var blurring = _props.blurring;
      var className = _props.className;
      var clearing = _props.clearing;
      var color = _props.color;
      var disabled = _props.disabled;
      var container = _props.container;
      var spacing = _props.spacing;
      var emphasis = _props.emphasis;
      var floated = _props.floated;
      var inverted = _props.inverted;
      var loading = _props.loading;
      var vertical = _props.vertical;
      var type = _props.type;
      var zIndex = _props.zIndex;

      var other = _objectWithoutProperties(_props, ['component', 'defaultClasses', 'children', 'aligned', 'attached', 'basic', 'blurring', 'className', 'clearing', 'color', 'disabled', 'container', 'spacing', 'emphasis', 'floated', 'inverted', 'loading', 'vertical', 'type', 'zIndex']);
      /* eslint-enable no-use-before-define */

      other.className = (0, _classnames2.default)(this.props.className, this.getClasses());
      other.style = this.getStyle();

      var Component = component;
      return _react2.default.createElement(
        Component,
        other,
        children
      );
    }
  }, {
    key: 'getClasses',
    value: function getClasses() {
      var classes = {
        // default
        ui: this.props.defaultClasses,

        // positioning
        right: false,
        left: false,
        center: false,
        top: false,
        bottom: false,

        // types
        raised: this.props.type === 'raised',
        stacked: this.props.type === 'stacked',
        piled: this.props.type === 'piled',
        vertical: this.props.vertical,

        // states
        disabled: this.props.disabled,
        loading: this.props.loading,

        // variations
        aligned: this.props.aligned,
        attached: this.props.attached,
        basic: this.props.basic,
        blurring: this.props.blurring,
        clearing: this.props.clearing,
        compact: this.props.spacing === 'fitted',
        container: this.props.container,
        floated: this.props.floated,
        inverted: this.props.inverted,
        padded: this.props.spacing === 'padded',
        primary: this.props.emphasis === 'primary',
        secondary: this.props.emphasis === 'secondary',
        tertiary: this.props.emphasis === 'tertiary',

        // component
        segment: this.props.defaultClasses
      };

      classes[this.props.color] = !!this.props.color;

      return (0, _utilities.validateClassProps)(classes, this.props, validProps);
    }
  }, {
    key: 'getStyle',
    value: function getStyle() {
      var style = this.props.style;

      if (this.props.type === 'piled' && !style.zIndex) {
        style.zIndex = this.props.zIndex || 0;
      }

      return style;
    }
  }]);

  return Segment;
}(_react2.default.Component), _class.defaultProps = _extends({}, _defaultProps2.default.defaultProps, {
  attached: false,
  style: {}
}), _temp);
exports.default = Segment;
//# sourceMappingURL=segment.js.map