'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactAddonsShallowCompare = require('react-addons-shallow-compare');

var _reactAddonsShallowCompare2 = _interopRequireDefault(_reactAddonsShallowCompare);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _defaultProps = require('../../defaultProps');

var _defaultProps2 = _interopRequireDefault(_defaultProps);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * Controlled accordion
 */
var Accordion = (_temp = _class = function (_React$Component) {
    _inherits(Accordion, _React$Component);

    function Accordion(props) {
        _classCallCheck(this, Accordion);

        // Disallow to override animation style for now, since paddingTop and paddingBottom need to be animated too
        // I don't want to bother with dealing with unit measures for now, so just hardcode semantic EM values here and in body component
        // this.enterAnimation = {
        //     height: {
        //         val: 'auto',
        //         stiffness: 300,
        //         damping: 40,
        //         precision: 0.1
        //     },
        //     paddingTop: {
        //         val: 0.5,
        //         stiffness: 300,
        //         damping: 40,
        //         precision: 0.2
        //     }
        // };
        // this.enterAnimation.paddingBottom = {
        //     val: (props.styled) ? 1.5 : 1,
        //     stiffness: 300,
        //     damping: 40,
        //     precision: 0.3
        // }
        // this.enterAnimation.paddingBottom = (props.styled) ? 1.5 : 1; // em
        // this.enterAnimation.paddingBottom = 1.0; // em
        // this.leaveAnimation = {
        //     height: 0,
        //     paddingTop: 0,
        //     paddingBottom: 0
        // }
        var _this = _possibleConstructorReturn(this, Object.getPrototypeOf(Accordion).call(this, props));

        _this.onAccordionTitleClick = function (index) {
            _this.props.onAccordionChange(index);
        };

        return _this;
    }

    _createClass(Accordion, [{
        key: 'getChildContext',
        value: function getChildContext() {
            return {
                isAccordionChild: true
            };
        }
    }, {
        key: 'shouldComponentUpdate',
        value: function shouldComponentUpdate(nextProps, nextState) {
            return (0, _reactAddonsShallowCompare2.default)(this, nextProps, nextState);
        }

        /**
         * Accordion title click handler
         *
         * @param {number|string} index Index
         */

    }, {
        key: 'renderChildren',


        /**
         * Process children. Skips non active content
         */
        value: function renderChildren() {
            // not using child.type checking because these will fail if using some kind of HOC component
            var arrayChildren = _react2.default.Children.toArray(this.props.children);
            var newChild = [];
            for (var index = 0; index < arrayChildren.length; index++) {
                var child = arrayChildren[index];
                if (child.props.index) {
                    var active = false;
                    // This is accordion title
                    if (this.props.activeIndexes.indexOf(child.props.index) !== -1) {
                        // It should be active
                        active = true;
                    }
                    newChild.push(_react2.default.cloneElement(child, {
                        active: active,
                        key: child.key ? child.key : child.props.index,
                        onClick: this.onAccordionTitleClick
                    }));
                    var body = arrayChildren[index + 1];
                    if (body) {
                        newChild.push(_react2.default.cloneElement(body, {
                            active: active,
                            key: body.key ? body.key : 'content-' + child.props.index,
                            styled: this.props.styled,
                            animating: this.props.animating
                        }));
                        // skip next element
                        index++;
                    }
                }
            }
            return newChild;
        }
    }, {
        key: 'render',
        value: function render() {
            var _props = this.props;
            var animating = _props.animating;
            var component = _props.component;
            var children = _props.children;
            var defaultClasses = _props.defaultClasses;
            var activeIndexes = _props.activeIndexes;
            var fluid = _props.fluid;
            var inverted = _props.inverted;
            var onAccordionChange = _props.onAccordionChange;
            var styled = _props.styled;
            var enterAnimation = _props.enterAnimation;
            var leaveAnimation = _props.leaveAnimation;

            var other = _objectWithoutProperties(_props, ['animating', 'component', 'children', 'defaultClasses', 'activeIndexes', 'fluid', 'inverted', 'onAccordionChange', 'styled', 'enterAnimation', 'leaveAnimation']);

            var Component = component;

            other.className = (0, _classnames2.default)(other.className, this.getClasses());

            return _react2.default.createElement(
                Component,
                other,
                this.renderChildren()
            );
        }
    }, {
        key: 'getClasses',
        value: function getClasses() {
            return {
                // default
                ui: this.props.defaultClasses && !this.context.isAccordionChild,

                // positioning

                // types
                styled: this.props.styled,

                // variations
                fluid: this.props.fluid,
                inverted: this.props.inverted,

                // component
                accordion: this.props.defaultClasses
            };
        }
    }]);

    return Accordion;
}(_react2.default.Component), _class.contextTypes = {
    isAccordionChild: _react2.default.PropTypes.bool
}, _class.childContextTypes = {
    isAccordionChild: _react2.default.PropTypes.bool
}, _class.defaultProps = _extends({}, _defaultProps2.default.defaultProps, {
    animating: true,
    activeIndexes: [],
    onAccordionChange: function onAccordionChange() {}
}), _temp);
exports.default = Accordion;
//# sourceMappingURL=accordion.js.map