'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactAddonsShallowCompare = require('react-addons-shallow-compare');

var _reactAddonsShallowCompare2 = _interopRequireDefault(_reactAddonsShallowCompare);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _reactMeasure = require('react-measure');

var _reactMeasure2 = _interopRequireDefault(_reactMeasure);

var _reactMotion = require('react-motion');

var _defaultProps = require('../../defaultProps');

var _defaultProps2 = _interopRequireDefault(_defaultProps);

var _animationUtils = require('../../animationUtils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * Accordion body (content)
 */
var AccordionBody = (_temp = _class = function (_React$Component) {
    _inherits(AccordionBody, _React$Component);

    function AccordionBody(props) {
        _classCallCheck(this, AccordionBody);

        var _this = _possibleConstructorReturn(this, Object.getPrototypeOf(AccordionBody).call(this, props));

        _this.onMeasure = function (dimensions) {
            if (dimensions && dimensions.height && dimensions.height !== _this.state.height) {
                _this.setState({
                    height: dimensions.height
                });
            }
        };

        _this.onAnimationRest = function () {
            _this.setState({ closing: false });
        };

        _this.state = {
            height: 1,
            closing: false
        };
        return _this;
    }

    _createClass(AccordionBody, [{
        key: 'componentWillReceiveProps',
        value: function componentWillReceiveProps(nextProps) {
            if (nextProps.active !== this.state.active) {
                if (!nextProps.active) {
                    this.setState({
                        closing: true
                    });
                }
            }
        }
    }, {
        key: 'shouldComponentUpdate',
        value: function shouldComponentUpdate(nextProps, nextState) {
            return (0, _reactAddonsShallowCompare2.default)(this, nextProps, nextState);
        }

        /**
         * Dimensions was changed
         * @param dimensions
         */

    }, {
        key: 'getAnimationStyle',


        /**
         * Return animation style
         * @param interpolatedStyle
         * @returns {{paddingTop: string, paddingBottom: string, height: number}}
         */
        value: function getAnimationStyle(interpolatedStyle) {
            return {
                paddingTop: interpolatedStyle.paddingTop + 'em',
                paddingBottom: interpolatedStyle.paddingBottom + 'em',
                height: interpolatedStyle.height
            };
        }
    }, {
        key: 'render',
        value: function render() {
            var _this2 = this;

            var _props = this.props;
            var animating = _props.animating;
            var component = _props.component;
            var children = _props.children;
            var defaultClasses = _props.defaultClasses;
            var active = _props.active;
            var style = _props.style;
            var styled = _props.styled;

            var other = _objectWithoutProperties(_props, ['animating', 'component', 'children', 'defaultClasses', 'active', 'style', 'styled']);

            var Component = component;
            other.className = (0, _classnames2.default)(other.className, {
                content: defaultClasses,
                active: active
            });

            var initialStyle = style ? _extends({}, style, { overflow: 'hidden' }) : { overflow: 'hidden' };

            var motionStyle = void 0;
            if (active) {
                motionStyle = {
                    height: (0, _reactMotion.spring)(this.state.height),
                    paddingTop: (0, _reactMotion.spring)(0.5),
                    paddingBottom: styled ? (0, _reactMotion.spring)(1.5) : (0, _reactMotion.spring)(1)
                };
            } else {
                motionStyle = {
                    height: (0, _reactMotion.spring)(0),
                    paddingTop: (0, _reactMotion.spring)(0),
                    paddingBottom: (0, _reactMotion.spring)(0)
                };
            }

            if (!animating) {
                return _react2.default.createElement(
                    Component,
                    other,
                    children
                );
            }

            return _react2.default.createElement(
                _reactMotion.Motion,
                { defaultStyle: this.initialAnimation,
                    style: motionStyle,
                    onRest: this.onAnimationRest
                },
                function (interpolatedStyle) {
                    var animationStyle = _this2.getAnimationStyle(interpolatedStyle);
                    var visibleStyle = active ? { display: 'block' } : _this2.state.closing ? { display: 'block' } : { display: 'none' };
                    return _react2.default.createElement(
                        _reactMeasure2.default,
                        { accurate: true,
                            whitelist: ['height'],
                            onMeasure: _this2.onMeasure
                        },
                        _react2.default.createElement(
                            Component,
                            _extends({}, other, {
                                style: _extends({}, initialStyle, visibleStyle, animationStyle)
                            }),
                            children
                        )
                    );
                }
            );
        }
    }]);

    return AccordionBody;
}(_react2.default.Component), _class.defaultProps = _extends({}, _defaultProps2.default.defaultProps, {
    animating: true,
    active: false,
    styled: false
}), _temp);
exports.default = AccordionBody;
//# sourceMappingURL=accordionbody.js.map