'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactAddonsShallowCompare = require('react-addons-shallow-compare');

var _reactAddonsShallowCompare2 = _interopRequireDefault(_reactAddonsShallowCompare);

var _reactMeasure = require('react-measure');

var _reactMeasure2 = _interopRequireDefault(_reactMeasure);

var _reactMotion = require('react-motion');

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _utilities = require('../../utilities');

var _defaultProps = require('../../defaultProps');

var _defaultProps2 = _interopRequireDefault(_defaultProps);

var _animationUtils = require('../../animationUtils');

var _animationUtils2 = _interopRequireDefault(_animationUtils);

var _content = require('./../../elements/simple/content');

var _content2 = _interopRequireDefault(_content);

var _loader = require('./../../elements/loader/loader');

var _loader2 = _interopRequireDefault(_loader);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Dimmer = (_temp = _class = function (_React$Component) {
    _inherits(Dimmer, _React$Component);

    /* eslint-enable */

    function Dimmer(props) {
        _classCallCheck(this, Dimmer);

        var _this = _possibleConstructorReturn(this, Object.getPrototypeOf(Dimmer).call(this, props));

        _this.onDimmerMeasure = function (dimensions) {
            if (dimensions && (dimensions.height && dimensions.height !== _this.state.dimmerHeight || dimensions.width && dimensions.width !== _this.state.dimmerWidth)) {
                _this.setState({
                    dimmerHeight: dimensions.height,
                    dimmerWidth: dimensions.width
                });
            }
        };

        _this.onAnimationRest = function () {
            _this.setState({ animating: false });
        };

        _this.state = {
            animating: false,
            dimmerHeight: 1,
            dimmerWidth: 1
        };

        _this.dimmerActiveStyle = {
            display: 'block'
        };

        _this.dimmerHiddenStyle = {
            display: 'none'
        };
        return _this;
    }

    /* eslint-disable */


    // This forces <Content> to add a centered div below it.


    _createClass(Dimmer, [{
        key: 'getChildContext',
        value: function getChildContext() {
            return {
                isDimmerChild: true
            };
        }
    }, {
        key: 'componentWillReceiveProps',
        value: function componentWillReceiveProps(nextProps) {
            if (this.props.active !== nextProps.active) {
                this.setState({ animating: true });
            }
        }
    }, {
        key: 'shouldComponentUpdate',
        value: function shouldComponentUpdate(nextProps, nextState) {
            return (0, _reactAddonsShallowCompare2.default)(this, nextProps, nextState);
        }
        /**
         * Modal dimensions was changed
         * @param dimensions
         */


        /**
         * Animation completed
         */

    }, {
        key: 'getAnimationStyle',


        /**
         * Return animation style to apply
         * @param interpolatedStyle
         * @param dimensions
         */
        value: function getAnimationStyle(interpolatedStyle, dimensions) {
            var _props = this.props;
            var active = _props.active;
            var onAnimationStyle = _props.onAnimationStyle;

            if (onAnimationStyle && typeof onAnimationStyle === "function") {
                return onAnimationStyle(interpolatedStyle, dimensions, active);
            }
            return {
                opacity: interpolatedStyle.opacity
            };
        }

        /**
         * Render dimmer children
         */

    }, {
        key: 'renderChildren',
        value: function renderChildren() {
            var _props2 = this.props;
            var children = _props2.children;
            var noWrapChildren = _props2.noWrapChildren;

            if (noWrapChildren) {
                return children;
            } else {
                return (0, _utilities.hasChild)(children, Dimmer.Components.Loader) ? children : _react2.default.createElement(
                    Dimmer.Components.Content,
                    null,
                    children
                );
            }
        }

        /**
         * Render dimmer
         * @param interpolatedStyle
         * @returns {XML}
         */

    }, {
        key: 'renderDimmer',
        value: function renderDimmer(interpolatedStyle) {
            var _props3 = this.props;
            var active = _props3.active;
            var children = _props3.children;
            var component = _props3.component;
            var defaultClasses = _props3.defaultClasses;
            var initialAnimation = _props3.initialAnimation;
            var enterAnimation = _props3.enterAnimation;
            var leaveAnimation = _props3.leaveAnimation;
            var page = _props3.page;
            var inverted = _props3.inverted;
            var noWrapChildren = _props3.noWrapChildren;
            var closePortal = _props3.closePortal;

            var other = _objectWithoutProperties(_props3, ['active', 'children', 'component', 'defaultClasses', 'initialAnimation', 'enterAnimation', 'leaveAnimation', 'page', 'inverted', 'noWrapChildren', 'closePortal']);

            var animatingStyle = this.getAnimationStyle(interpolatedStyle, { height: this.state.dimmerHeight, width: this.state.dimmerWidth });
            /* eslint-disable */
            // Apply additional styling for dimmer when visible/hidden
            var dimmerStyle = active ? this.dimmerActiveStyle : this.state.animating ? this.dimmerActiveStyle : this.dimmerHiddenStyle;
            /* eslint-enable */
            var Component = component;
            other.className = (0, _classnames2.default)(other.className, this.getClasses());
            // Final dimmer style
            var style = _extends({}, other.style, dimmerStyle, animatingStyle);
            return _react2.default.createElement(
                _reactMeasure2.default,
                { accurate: true,
                    whitelist: ["height", "width"],
                    onMeasure: this.onDimmerMeasure
                },
                _react2.default.createElement(
                    Component,
                    _extends({}, other, {
                        key: 'dimmer',
                        style: style
                    }),
                    this.renderChildren()
                )
            );
        }
    }, {
        key: 'render',
        value: function render() {
            var _this2 = this;

            /* eslint-disable no-use-before-define */
            var _props4 = this.props;
            var active = _props4.active;
            var initialAnimation = _props4.initialAnimation;
            var enterAnimation = _props4.enterAnimation;
            var leaveAnimation = _props4.leaveAnimation;
            /* eslint-enable no-use-before-define */

            var motionStyle = (0, _animationUtils.getMotionStyle)(initialAnimation, enterAnimation, leaveAnimation, active);
            return _react2.default.createElement(
                _reactMotion.Motion,
                { defaultStyle: initialAnimation,
                    style: motionStyle,
                    onRest: this.onAnimationRest
                },
                function (interpolatedStyle) {
                    return _this2.renderDimmer(interpolatedStyle);
                }
            );
        }
    }, {
        key: 'getClasses',
        value: function getClasses() {
            return {
                ui: this.props.defaultClasses,
                dimmer: this.props.defaultClasses,
                active: this.props.active,
                page: this.props.page,
                inverted: this.props.inverted
            };
        }
    }]);

    return Dimmer;
}(_react2.default.Component), _class.childContextTypes = {
    isDimmerChild: _react2.default.PropTypes.bool
}, _class.defaultProps = _extends({}, _defaultProps2.default.defaultProps, {
    active: false,
    initialAnimation: {
        opacity: 0.3
    },
    enterAnimation: {
        opacity: (0, _reactMotion.spring)(1, { stiffness: 500, damping: 40, precision: 1 })
    },
    leaveAnimation: {
        opacity: (0, _reactMotion.spring)(0, { stiffness: 900, damping: 40, precision: 1 })
    },
    page: false,
    inverted: false,
    noWrapChildren: false
}), _class.Components = {
    Content: _content2.default,
    Loader: _loader2.default
}, _temp);
exports.default = Dimmer;
//# sourceMappingURL=dimmer.js.map