'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _reactEventListener = require('react-event-listener');

var _reactEventListener2 = _interopRequireDefault(_reactEventListener);

var _reactAddonsShallowCompare = require('react-addons-shallow-compare');

var _reactAddonsShallowCompare2 = _interopRequireDefault(_reactAddonsShallowCompare);

var _elementType = require('react-prop-types/lib/elementType');

var _elementType2 = _interopRequireDefault(_elementType);

var _reactMotion = require('react-motion');

var _reactMeasure = require('react-measure');

var _reactMeasure2 = _interopRequireDefault(_reactMeasure);

var _utilities = require('../../utilities');

var _animationUtils = require('../../animationUtils');

var _animationUtils2 = _interopRequireDefault(_animationUtils);

var _dropdownelement = require('./dropdownelement');

var _dropdownelement2 = _interopRequireDefault(_dropdownelement);

var _icon = require('./../../elements/icon/icon');

var _icon2 = _interopRequireDefault(_icon);

var _text = require('./../../elements/simple/text');

var _text2 = _interopRequireDefault(_text);

var _menu = require('./../../views/menu/menu');

var _menu2 = _interopRequireDefault(_menu);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * Dropdown menu with animations
 */
var DropdownMenu = (_temp = _class = function (_React$Component) {
    _inherits(DropdownMenu, _React$Component);

    /* eslint-enable */

    function DropdownMenu(props) {
        _classCallCheck(this, DropdownMenu);

        var _this = _possibleConstructorReturn(this, Object.getPrototypeOf(DropdownMenu).call(this, props));

        _this.onOutsideDropdownClick = function (e) {
            var _this$props = _this.props;
            var active = _this$props.active;
            var onRequestClose = _this$props.onRequestClose;

            if (!active) {
                return;
            }
            var dropdownElement = _reactDom2.default.findDOMNode(_this);
            if (dropdownElement) {
                if (!(0, _utilities.isNodeInRoot)(e.target, dropdownElement)) {
                    onRequestClose();
                }
            }
        };

        _this.onMenuMeasure = function (dimensions) {
            if (dimensions && (dimensions.height && dimensions.height !== _this.state.menuHeight || dimensions.width && dimensions.width !== _this.state.menuWidth)) {
                _this.setState({
                    menuHeight: dimensions.height,
                    menuWidth: dimensions.width
                });
            }
        };

        _this.onAnimationRest = function () {
            _this.setState({ animating: false });
        };

        _this.state = {
            menuHeight: 20,
            menuWidth: 20,
            animating: false
        };

        _this.visibleMenuStyle = {
            overflow: 'hidden',
            display: 'block'
        };

        _this.hiddenMenuStyle = {
            display: 'none'
        };
        return _this;
    }

    /* eslint-disable */


    _createClass(DropdownMenu, [{
        key: 'componentWillReceiveProps',
        value: function componentWillReceiveProps(nextProps) {
            if (this.props.active != nextProps.active) {
                this.setState({ animating: true });
            }
        }
    }, {
        key: 'shouldComponentUpdate',
        value: function shouldComponentUpdate(nextProps, nextState) {
            return (0, _reactAddonsShallowCompare2.default)(this, nextProps, nextState);
        }

        /**
         * Outside dropdown click
         * @param {React.MouseEvent} e
         */

    }, {
        key: 'getAnimationStyle',
        value: function getAnimationStyle(interpolatedStyle, dimensions) {
            var _props = this.props;
            var active = _props.active;
            var onAnimationStyle = _props.onAnimationStyle;

            if (onAnimationStyle) {
                return onAnimationStyle(interpolatedStyle, dimensions, active);
            }
            return {
                height: (0, _animationUtils.valueFromPercents)(interpolatedStyle.height, dimensions.height)
            };
        }

        /**
         * Renders dropdown icon
         * @returns {*}
         */

    }, {
        key: 'renderMenuIcon',
        value: function renderMenuIcon() {
            if (typeof this.props.component === 'function') {
                return null;
            } else {
                return _react2.default.createElement(DropdownMenu.Components.Icon, { name: this.props.icon });
            }
        }

        /**
         * Renders dropdown text
         * @returns {*}
         */

    }, {
        key: 'renderMenuText',
        value: function renderMenuText() {
            if (typeof this.props.component === 'function' || !this.props.label) {
                return null;
            } else {
                return _react2.default.createElement(
                    DropdownMenu.Components.Text,
                    null,
                    this.props.label
                );
            }
        }

        /**
         * Render menu
         * @param interpolatedStyle
         */

    }, {
        key: 'renderMenu',
        value: function renderMenu(interpolatedStyle) {
            /* eslint-disable no-use-before-define */
            var _props2 = this.props;
            var active = _props2.active;
            var children = _props2.children;
            var menuComponent = _props2.menuComponent;
            var menuValue = _props2.menuValue;
            var onMenuChange = _props2.onMenuChange;
            var onMenuItemClick = _props2.onMenuItemClick;
            /* eslint-enable no-use-before-define */

            var MenuComponent = menuComponent || DropdownMenu.Components.Menu;

            var menuStyle = active ? this.visibleMenuStyle : this.state.animating ? this.visibleMenuStyle : this.hiddenMenuStyle;
            var animatingStyle = this.getAnimationStyle(interpolatedStyle, { height: this.state.menuHeight, width: this.state.menuWidth });

            return _react2.default.createElement(
                _reactMeasure2.default,
                { whitelist: ['height', 'width'],
                    onMeasure: this.onMenuMeasure,
                    accurate: true,
                    key: 'measure'
                },
                _react2.default.createElement(
                    MenuComponent,
                    { key: 'menu',
                        menuValue: menuValue,
                        onMenuChange: onMenuChange,
                        onMenuItemClick: onMenuItemClick,
                        style: _extends({}, menuStyle, animatingStyle)
                    },
                    children
                )
            );
        }

        /**
         * Render
         * @returns {JSX.Element}
         */

    }, {
        key: 'render',
        value: function render() {
            var _this2 = this;

            /* eslint-disable no-use-before-define */
            var _props3 = this.props;
            var active = _props3.active;
            var initialAnimation = _props3.initialAnimation;
            var enterAnimation = _props3.enterAnimation;
            var leaveAnimation = _props3.leaveAnimation;
            var children = _props3.children;
            var icon = _props3.icon;
            var label = _props3.label;
            var menuComponent = _props3.menuComponent;
            var menuValue = _props3.menuValue;
            var onMenuChange = _props3.onMenuChange;
            var onMenuItemClick = _props3.onMenuItemClick;
            var onRequestClose = _props3.onRequestClose;
            var onAnimationStyle = _props3.onAnimationStyle;

            var other = _objectWithoutProperties(_props3, ['active', 'initialAnimation', 'enterAnimation', 'leaveAnimation', 'children', 'icon', 'label', 'menuComponent', 'menuValue', 'onMenuChange', 'onMenuItemClick', 'onRequestClose', 'onAnimationStyle']);
            /* eslint-enable no-use-before-define */

            var motionStyle = (0, _animationUtils.getMotionStyle)(initialAnimation, enterAnimation, leaveAnimation, active);

            return _react2.default.createElement(
                DropdownMenu.Components.DropdownElement,
                _extends({}, other, {
                    active: active
                }),
                _react2.default.createElement(_reactEventListener2.default, { target: document,
                    capture: true,
                    onMouseDown: this.onOutsideDropdownClick,
                    onTouchStart: this.onOutsideDropdownClick }),
                this.renderMenuText(),
                this.renderMenuIcon(),
                _react2.default.createElement(
                    _reactMotion.Motion,
                    { defaultStyle: initialAnimation,
                        style: motionStyle,
                        onRest: this.onAnimationRest
                    },
                    function (interpolatedStyle) {
                        return _this2.renderMenu(interpolatedStyle);
                    }
                )
            );
        }
    }]);

    return DropdownMenu;
}(_react2.default.Component), _class.defaultProps = _extends({}, _dropdownelement2.default.defaultProps, {
    active: false,
    icon: 'dropdown',
    initialAnimation: {
        height: 0 // 0%
    },
    enterAnimation: {
        height: (0, _reactMotion.spring)(100, { stiffness: 700, damping: 50, precision: 40 }) // 100%
    },
    leaveAnimation: {
        height: (0, _reactMotion.spring)(0, { stiffness: 700, damping: 50, precision: 40 }) // 0%
    },
    onMenuItemClick: function onMenuItemClick() {},
    onMenuChange: function onMenuChange() {},
    onRequestClose: function onRequestClose() {}
}), _class.Components = {
    Icon: _icon2.default,
    Text: _text2.default,
    Menu: _menu2.default,
    DropdownElement: _dropdownelement2.default
}, _temp);
exports.default = DropdownMenu;
//# sourceMappingURL=dropdownmenu.js.map