'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _modal = require('../modal');

var _modal2 = _interopRequireDefault(_modal);

var _button = require('../../../elements/button/button');

var _button2 = _interopRequireDefault(_button);

var _icon = require('./../../../elements/icon/icon');

var _icon2 = _interopRequireDefault(_icon);

var _header = require('./../../../elements/header/header');

var _header2 = _interopRequireDefault(_header);

var _content = require('./../../../elements/simple/content');

var _content2 = _interopRequireDefault(_content);

var _description = require('./../../../elements/simple/description');

var _description2 = _interopRequireDefault(_description);

var _actions = require('./../../../elements/simple/actions');

var _actions2 = _interopRequireDefault(_actions);

var _labeledbutton = require('./../../../elements/button/labeledbutton');

var _labeledbutton2 = _interopRequireDefault(_labeledbutton);

var _animationUtils = require('../../../animationUtils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var MyCustomAnimatedModal = function (_React$Component) {
    _inherits(MyCustomAnimatedModal, _React$Component);

    function MyCustomAnimatedModal(props) {
        _classCallCheck(this, MyCustomAnimatedModal);

        var _this = _possibleConstructorReturn(this, Object.getPrototypeOf(MyCustomAnimatedModal).call(this, props));

        _this.onCloseModal = function () {
            _this.setState({
                active: false
            });
        };

        _this.onAnimationStyle = function (interpolatedStyle, dimensions, active) {
            return {
                transform: 'translateY(' + interpolatedStyle.y + 'px)'
            };
        };

        _this.state = {
            active: false
        };
        return _this;
    }

    _createClass(MyCustomAnimatedModal, [{
        key: 'render',
        value: function render() {
            var _this2 = this;

            return _react2.default.createElement(
                'div',
                null,
                _react2.default.createElement(
                    _button2.default,
                    { onClick: function onClick() {
                            return _this2.setState({ active: true });
                        } },
                    'Open modal'
                ),
                _react2.default.createElement(
                    _modal2.default,
                    { onRequestClose: this.onCloseModal,
                        active: this.state.active,
                        initialAnimation: {
                            y: -500
                        },
                        enterAnimation: {
                            y: 0
                        },
                        leaveAnimation: {
                            y: (0, _animationUtils.spring)(800, { stiffness: 800, damping: 40, precision: 1 })
                        },
                        onAnimationStyle: this.onAnimationStyle
                    },
                    _react2.default.createElement(_icon2.default, { name: 'close', onClick: this.onCloseModal.bind(this) }),
                    _react2.default.createElement(
                        _header2.default,
                        null,
                        'Select a photo'
                    ),
                    _react2.default.createElement(
                        _content2.default,
                        { image: true },
                        _react2.default.createElement(Image, { size: 'medium', wrapComponent: true, src: 'http://semantic-ui.com/images/avatar2/large/rachel.png' }),
                        _react2.default.createElement(
                            _description2.default,
                            null,
                            _react2.default.createElement(
                                _header2.default,
                                null,
                                'Default profile image'
                            ),
                            _react2.default.createElement(
                                'p',
                                null,
                                'We\'ve found the following gravatar image associated with your e-mail address.'
                            ),
                            _react2.default.createElement(
                                'p',
                                null,
                                'Is it okay to use this photo?'
                            )
                        )
                    ),
                    _react2.default.createElement(
                        _actions2.default,
                        null,
                        _react2.default.createElement(
                            _button2.default,
                            { emphasis: 'negative', onClick: this.onCloseModal.bind(this) },
                            'Nope'
                        ),
                        _react2.default.createElement(
                            _labeledbutton2.default,
                            { emphasis: 'positive',
                                label: 'checkmark',
                                labelType: 'icon',
                                onClick: this.onCloseModal.bind(this)
                            },
                            'Yep, that\'s me'
                        )
                    )
                )
            );
        }
    }]);

    return MyCustomAnimatedModal;
}(_react2.default.Component);

_react2.default.createElement(MyCustomAnimatedModal, null);
//# sourceMappingURL=customAnimation.js.map