'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _reactMotion = require('react-motion');

var _reactMeasure = require('react-measure');

var _reactMeasure2 = _interopRequireDefault(_reactMeasure);

var _reactPortal = require('react-portal');

var _reactPortal2 = _interopRequireDefault(_reactPortal);

var _reactEventListener = require('react-event-listener');

var _reactEventListener2 = _interopRequireDefault(_reactEventListener);

var _reactAddonsShallowCompare = require('react-addons-shallow-compare');

var _reactAddonsShallowCompare2 = _interopRequireDefault(_reactAddonsShallowCompare);

var _utilities = require('../../utilities');

var _dimmer = require('../dimmer/dimmer');

var _dimmer2 = _interopRequireDefault(_dimmer);

var _modalelement = require('./modalelement');

var _modalelement2 = _interopRequireDefault(_modalelement);

var _animationUtils = require('../../animationUtils');

var _animationUtils2 = _interopRequireDefault(_animationUtils);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * Modal is modal
 */
var Modal = (_temp = _class = function (_React$Component) {
    _inherits(Modal, _React$Component);

    /* eslint-enable */

    function Modal(props) {
        _classCallCheck(this, Modal);

        var _this = _possibleConstructorReturn(this, Object.getPrototypeOf(Modal).call(this, props));

        _this.onPressEsc = function (event) {
            if (event.keyCode !== 27) {
                return;
            }

            event.stopPropagation();
            _this.props.onRequestClose(event);
        };

        _this.onOutsideClick = function (event) {
            if (!_this.state.active || _this.state.closing) {
                return;
            }
            if (!_this.modal) {
                return;
            }
            if ((0, _utilities.isNodeInRoot)(event.target, _reactDom2.default.findDOMNode(_this.modal))) {
                return;
            }
            event.stopPropagation();
            _this.props.onRequestClose(event);
        };

        _this.onModalMeasure = function (dimensions) {
            if (dimensions && (dimensions.height && dimensions.height !== _this.state.modalHeight || dimensions.width && dimensions.width !== _this.state.modalWidth)) {
                _this.setState({
                    modalHeight: dimensions.height,
                    modalWidth: dimensions.width
                });
            }
        };

        _this.onAnimationRest = function () {
            if (!_this.state.active && _this.state.closing) {
                _this.setState({ closing: false });
            }
        };

        _this.state = {
            modalHeight: 1,
            modalWidth: 1,
            active: props.active,
            closing: false
        };

        _this.modal = null;
        return _this;
    }

    /* eslint-disable */


    _createClass(Modal, [{
        key: 'getChildContext',
        value: function getChildContext() {
            return {
                isModalChild: true
            };
        }
    }, {
        key: 'componentWillReceiveProps',
        value: function componentWillReceiveProps(nextProps) {
            if (nextProps.active !== this.state.active) {
                if (nextProps.active) {
                    this.setState({
                        active: true,
                        closing: false
                    });
                } else {
                    this.setState({
                        active: false,
                        closing: true
                    });
                }
            }
        }
    }, {
        key: 'shouldComponentUpdate',
        value: function shouldComponentUpdate(nextProps, nextState) {
            // since we're changing state immediately after componentDidUpdate we need to prevent re-rendering loop
            return (0, _reactAddonsShallowCompare2.default)(this, nextProps, nextState);
        }

        /**
         * Modal dimensions was changed
         * @param dimensions
         */


        /**
         * Animation completed
         */

    }, {
        key: 'getAnimationStyle',
        value: function getAnimationStyle(interpolatedStyle, dimensions) {
            var onAnimationStyle = this.props.onAnimationStyle;

            if (onAnimationStyle && typeof onAnimationStyle === "function") {
                return onAnimationStyle(interpolatedStyle, dimensions, this.state.active);
            }
            return {
                opacity: interpolatedStyle.opacity,
                transform: 'scale(' + interpolatedStyle.scale + ')'
            };
        }

        /**
         * Render modal element
         * @param interpolatedStyle Interpolated style
         * @returns {*}
         */

    }, {
        key: 'renderModal',
        value: function renderModal(interpolatedStyle) {
            var _this2 = this;

            var _props = this.props;
            var component = _props.component;
            var defaultClasses = _props.defaultClasses;
            var initialAnimation = _props.initialAnimation;
            var enterAnimation = _props.enterAnimation;
            var leaveAnimation = _props.leaveAnimation;
            var children = _props.children;
            var dimmed = _props.dimmed;
            var onOutsideClick = _props.onOutsideClick;
            var style = _props.style;
            var zIndex = _props.zIndex;
            var onModalOpened = _props.onModalOpened;
            var onModalClosed = _props.onModalClosed;
            var onRequestClose = _props.onRequestClose;
            var onAnimationStyle = _props.onAnimationStyle;

            var other = _objectWithoutProperties(_props, ['component', 'defaultClasses', 'initialAnimation', 'enterAnimation', 'leaveAnimation', 'children', 'dimmed', 'onOutsideClick', 'style', 'zIndex', 'onModalOpened', 'onModalClosed', 'onRequestClose', 'onAnimationStyle']);

            var positionTop = 0;
            var scrolling = false;
            // Modal is too big, set the scrolling state then
            if (this.state.modalHeight > window.innerHeight) {
                scrolling = true;
            } else {
                positionTop = window.innerHeight / 2 - this.state.modalHeight / 2;
            }

            var animationStyle = this.getAnimationStyle(interpolatedStyle, {
                height: this.state.modalHeight,
                width: this.state.modalWidth
            });
            var modalStyle = _extends({}, style, {
                position: 'fixed',
                top: positionTop
            }, animationStyle);

            return _react2.default.createElement(
                _reactMeasure2.default,
                { accurate: true,
                    whitelist: ["height", "width"],
                    shouldMeasure: true,
                    onMeasure: this.onModalMeasure
                },
                _react2.default.createElement(
                    Modal.Components.ModalElement,
                    _extends({}, other, {
                        active: this.state.active || !this.state.active && this.state.closing,
                        key: 'modal',
                        ref: function ref(_ref) {
                            return _this2.modal = _ref;
                        },
                        scrolling: scrolling,
                        style: modalStyle
                    }),
                    children
                )
            );
        }
    }, {
        key: 'render',
        value: function render() {
            var _this3 = this;

            var _props2 = this.props;
            var initialAnimation = _props2.initialAnimation;
            var enterAnimation = _props2.enterAnimation;
            var leaveAnimation = _props2.leaveAnimation;
            var zIndex = _props2.zIndex;
            var onModalOpened = _props2.onModalOpened;
            var onModalClosed = _props2.onModalClosed;

            // Apply layer to portal to prevent clicking outside

            var portalStyle = {
                position: 'fixed',
                top: 0,
                bottom: 0,
                left: 0,
                right: 0,
                zIndex: zIndex
            };

            var springAnimationStyle = (0, _animationUtils.getMotionStyle)(initialAnimation, enterAnimation, leaveAnimation, this.state.active);
            return _react2.default.createElement(
                _reactPortal2.default,
                { isOpened: this.state.active || !this.state.active && this.state.closing,
                    style: portalStyle,
                    onOpen: onModalOpened,
                    onClose: onModalClosed
                },
                _react2.default.createElement(
                    Modal.Components.Dimmer,
                    { active: this.state.active,
                        page: true,
                        noWrapChildren: true,
                        className: 'modals'
                    },
                    _react2.default.createElement(_reactEventListener2.default, { target: document,
                        onKeyDown: this.onPressEsc,
                        onMouseDown: this.onOutsideClick,
                        onTouchStart: this.onOutsideClick }),
                    _react2.default.createElement(
                        _reactMotion.Motion,
                        { defaultStyle: initialAnimation,
                            style: springAnimationStyle,
                            onRest: this.onAnimationRest
                        },
                        function (interpolatedStyle) {
                            return _this3.renderModal(interpolatedStyle);
                        }
                    )
                )
            );
        }
    }]);

    return Modal;
}(_react2.default.Component), _class.childContextTypes = {
    isModalChild: _react2.default.PropTypes.bool
}, _class.defaultProps = _extends({}, _modalelement2.default.defaultProps, {
    onRequestClose: function onRequestClose() {},
    onModalOpened: function onModalOpened() {},
    onModalClosed: function onModalClosed() {},
    initialAnimation: {
        opacity: 0.5,
        scale: 0.5
    },
    enterAnimation: {
        opacity: (0, _reactMotion.spring)(1, { stiffness: 300, damping: 40, precision: 1 }),
        scale: (0, _reactMotion.spring)(1, { stiffness: 300, damping: 25, precision: 1 })
    },
    leaveAnimation: {
        opacity: (0, _reactMotion.spring)(0, { stiffness: 700, damping: 40, precision: 1 }),
        scale: (0, _reactMotion.spring)(0.5, { stiffness: 700, damping: 40, precision: 1 })
    },
    zIndex: 1000
}), _class.Components = {
    Dimmer: _dimmer2.default,
    ModalElement: _modalelement2.default
}, _temp);
exports.default = Modal;
//# sourceMappingURL=modal.js.map