'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _button = require('../../../elements/button/button');

var _button2 = _interopRequireDefault(_button);

var _popup = require('../popup');

var _popup2 = _interopRequireDefault(_popup);

var _animationUtils = require('../../../animationUtils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var MyCustomAnimatedPopup = function (_React$Component) {
    _inherits(MyCustomAnimatedPopup, _React$Component);

    function MyCustomAnimatedPopup(props) {
        _classCallCheck(this, MyCustomAnimatedPopup);

        var _this = _possibleConstructorReturn(this, Object.getPrototypeOf(MyCustomAnimatedPopup).call(this, props));

        _this.onButtonHoverEnter = function (event) {
            _this.setState({ popupActive: true, buttonEl: event.target });
        };

        _this.onPopupRequestClose = function () {
            _this.setState({ popupActive: false });
        };

        _this.onAnimationStyle = function (interpolatedStyle, dimensions) {
            return {
                transform: 'scaleY(' + interpolatedStyle.y + ')',
                transformOrigin: 'top left'
            };
        };

        _this.state = {
            popupActive: false,
            buttonEl: null
        };
        return _this;
    }

    _createClass(MyCustomAnimatedPopup, [{
        key: 'render',
        value: function render() {
            return _react2.default.createElement(
                'div',
                null,
                _react2.default.createElement(
                    _button2.default,
                    { onMouseEnter: this.onButtonHoverEnter },
                    'Hover Me!'
                ),
                _react2.default.createElement(
                    _popup2.default,
                    { active: this.state.popupActive,
                        onRequestClose: this.onPopupRequestClose,
                        target: this.state.buttonEl,
                        initialAnimation: {
                            y: 0
                        },
                        enterAnimation: {
                            y: (0, _animationUtils.spring)(1, { stiffness: 700, damping: 40, precision: 0.1 })
                        },
                        leaveAnimation: {
                            y: (0, _animationUtils.spring)(0, { stiffness: 700, damping: 40, precision: 0.1 })
                        },
                        onAnimationStyle: this.onAnimationStyle
                    },
                    'This is just popup'
                )
            );
        }
    }]);

    return MyCustomAnimatedPopup;
}(_react2.default.Component);

_react2.default.createElement(MyCustomAnimatedPopup, null);
//# sourceMappingURL=customAnimation.js.map