'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _reactMotion = require('react-motion');

var _reactMeasure = require('react-measure');

var _reactMeasure2 = _interopRequireDefault(_reactMeasure);

var _reactPortal = require('react-portal');

var _reactPortal2 = _interopRequireDefault(_reactPortal);

var _reactEventListener = require('react-event-listener');

var _reactEventListener2 = _interopRequireDefault(_reactEventListener);

var _lodash = require('lodash.throttle');

var _lodash2 = _interopRequireDefault(_lodash);

var _reactAddonsShallowCompare = require('react-addons-shallow-compare');

var _reactAddonsShallowCompare2 = _interopRequireDefault(_reactAddonsShallowCompare);

var _popupelement = require('./popupelement');

var _popupelement2 = _interopRequireDefault(_popupelement);

var _utilities = require('../../utilities');

var _animationUtils = require('../../animationUtils');

var _animationUtils2 = _interopRequireDefault(_animationUtils);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * Popup with animations
 */
var Popup = (_temp = _class = function (_React$Component) {
    _inherits(Popup, _React$Component);

    /* eslint-enable */

    function Popup(props) {
        _classCallCheck(this, Popup);

        // Handle resize / scrolls handler
        var _this = _possibleConstructorReturn(this, Object.getPrototypeOf(Popup).call(this, props));

        _this.onOutsideClick = function (event) {
            if (!_this.state.active || _this.state.closing) {
                return;
            }
            if (!_this.popupRef || !_this.popupRef.popupEl) {
                return;
            }
            if ((0, _utilities.isNodeInRoot)(event.target, _this.popupRef.popupEl)) {
                return;
            }
            event.stopPropagation();
            _this.props.onRequestClose(event);
        };

        _this.onAnimationRest = function () {
            if (!_this.state.active && _this.state.closing) {
                _this.setState({ closing: false });
            }
        };

        _this.onPopupMeasure = function (dimensions) {
            if (dimensions && (dimensions.height && dimensions.height !== _this.state.popupHeight || dimensions.width && dimensions.width !== _this.state.popupWidth)) {
                _this.setState({
                    popupHeight: dimensions.height,
                    popupWidth: dimensions.width
                });
            }
        };

        _this.handleResize = (0, _lodash2.default)(_this.setPlacement.bind(_this), 100);
        _this.handleScroll = (0, _lodash2.default)(_this.setPlacement.bind(_this, true), 100);

        /**
         * Array of current tried positions
         * @type {Array}
         */
        _this.positionsTried = [];

        _this.state = {
            popupWidth: 1,
            popupHeight: 1,
            active: _this.props.active,
            closing: false,
            // Need to save position to state, since it could be changed by autoPosition
            position: props.position, // eslint-disable-line
            positionStyleTop: '0px',
            positionStyleLeft: '0px'
        };

        _this.popupRef = null;
        return _this;
    }

    /* eslint-disable */


    _createClass(Popup, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            if (this.props.active) {
                // Set initial position for popup
                this.setPlacement();
            }
        }
    }, {
        key: 'componentWillReceiveProps',
        value: function componentWillReceiveProps(nextProps) {
            if (nextProps.active !== this.state.active) {
                if (nextProps.active) {
                    // Display popup, set active state
                    this.setState({
                        active: true,
                        position: nextProps.position
                    });
                } else {
                    this.positionsTried = [];
                    this.setState({
                        active: false,
                        closing: true
                    });
                }
            }
        }
    }, {
        key: 'shouldComponentUpdate',
        value: function shouldComponentUpdate(nextProps, nextState) {
            // since we're changing state immediately after componentDidUpdate we need to prevent re-rendering loop
            return (0, _reactAddonsShallowCompare2.default)(this, nextProps, nextState);
        }
    }, {
        key: 'componentDidUpdate',
        value: function componentDidUpdate() {
            // Set popup position after update
            this.setPlacement();
        }
        /**
         * Popup dimensions was changed
         * @param dimensions
         */

    }, {
        key: 'getAnimationStyle',


        /**
         * Return animation style for popup
         * @param interpolatedStyle
         * @param dimensions
         */
        value: function getAnimationStyle(interpolatedStyle, dimensions) {
            var onAnimationStyle = this.props.onAnimationStyle;

            if (onAnimationStyle) {
                return onAnimationStyle(interpolatedStyle, dimensions, this.state.active);
            }
            return {
                transform: 'scale(' + interpolatedStyle.scale + ')'
            };
        }

        /**
         * Renders popup
         * @param interpolatedStyles
         */

    }, {
        key: 'renderPopup',
        value: function renderPopup(interpolatedStyles) {
            var _this2 = this;

            // consuming position from props here since it's passing it from state
            /* eslint-disable no-use-before-define, react/prop-types */
            var _props = this.props;
            var active = _props.active;
            var autoPosition = _props.autoPosition;
            var distanceAway = _props.distanceAway;
            var lastResortPosition = _props.lastResortPosition;
            var offset = _props.offset;
            var initialAnimation = _props.initialAnimation;
            var enterAnimation = _props.enterAnimation;
            var leaveAnimation = _props.leaveAnimation;
            var onAnimationStyle = _props.onAnimationStyle;
            var onRequestClose = _props.onRequestClose;
            var prefer = _props.prefer;
            var position = _props.position;
            var preventElementClicks = _props.preventElementClicks;
            var requestCloseWhenOffScreen = _props.requestCloseWhenOffScreen;
            var target = _props.target;
            var style = _props.style;
            var zIndex = _props.zIndex;

            var other = _objectWithoutProperties(_props, ['active', 'autoPosition', 'distanceAway', 'lastResortPosition', 'offset', 'initialAnimation', 'enterAnimation', 'leaveAnimation', 'onAnimationStyle', 'onRequestClose', 'prefer', 'position', 'preventElementClicks', 'requestCloseWhenOffScreen', 'target', 'style', 'zIndex']);
            /* eslint-enable no-use-before-define, react/prop-types */

            // Create style for popup


            var positionStyle = {
                left: this.state.positionStyleLeft,
                top: this.state.positionStyleTop,
                bottom: 'auto',
                right: 'auto',
                display: 'block',
                position: 'fixed' // need it to be fixed to avoid it with bloating code with many checks
            };
            var popupStyle = style ? _extends({}, style, positionStyle) : positionStyle;

            var animationStyle = this.getAnimationStyle(interpolatedStyles, {
                height: this.state.popupHeight,
                width: this.state.popupWidth
            });
            return _react2.default.createElement(
                _reactMeasure2.default,
                { accurate: true,
                    whitelist: ['width', 'height'],
                    onMeasure: this.onPopupMeasure,
                    key: 'measure'
                },
                _react2.default.createElement(Popup.Components.PopupElement, _extends({}, other, {
                    key: 'popup',
                    position: this.state.position,
                    ref: function ref(_ref) {
                        return _this2.popupRef = _ref;
                    },
                    style: _extends({}, popupStyle, animationStyle) }))
            );
        }
    }, {
        key: 'render',
        value: function render() {
            var _this3 = this;

            // consuming position from props here since it's passing it from state
            /* eslint-disable no-use-before-define, react/prop-types */
            var _props2 = this.props;
            var initialAnimation = _props2.initialAnimation;
            var enterAnimation = _props2.enterAnimation;
            var leaveAnimation = _props2.leaveAnimation;
            var zIndex = _props2.zIndex;
            /* eslint-enable no-use-before-define, react/prop-types */

            // Apply invisible layer to portal if preventElementClicks is true

            var portalStyle = {
                position: 'fixed',
                top: 0,
                bottom: 0,
                left: 0,
                right: 0,
                zIndex: zIndex
            };

            var motionStyle = (0, _animationUtils.getMotionStyle)(initialAnimation, enterAnimation, leaveAnimation, this.state.active);

            return _react2.default.createElement(
                _reactPortal2.default,
                { isOpened: this.state.active || !this.state.active && this.state.closing,
                    style: this.props.preventElementClicks ? portalStyle : {}
                },
                _react2.default.createElement(
                    _reactEventListener2.default,
                    { target: 'window',
                        onResize: this.handleResize,
                        onScroll: this.handleScroll
                    },
                    _react2.default.createElement(
                        _reactEventListener2.default,
                        { target: document,
                            onMouseDown: this.onOutsideClick,
                            onTouchStart: this.onOutsideClick
                        },
                        _react2.default.createElement(
                            _reactMotion.Motion,
                            { defaultStyle: initialAnimation,
                                style: motionStyle,
                                onRest: this.onAnimationRest
                            },
                            function (interpolatedStyle) {
                                return _this3.renderPopup(interpolatedStyle);
                            }
                        )
                    )
                )
            );
        }

        /**
         * Return target element boundaries
         * @param element {HTMLElement}
         */

    }, {
        key: 'getTargetPosition',
        value: function getTargetPosition(element) {
            var rect = element.getBoundingClientRect();
            var left = rect.left;
            var top = rect.top;

            return {
                top: top,
                left: left,
                right: left + element.offsetWidth,
                bottom: top + element.offsetHeight,
                width: element.offsetWidth,
                height: element.offsetHeight,
                center: left + element.offsetWidth / 2,
                middle: top + element.offsetHeight / 2
            };
        }

        /**
         * Return popup element boundaries
         * @param element {HTMLElement}
         */

    }, {
        key: 'getPopupDimensions',
        value: function getPopupDimensions(element) {
            return {
                width: element.offsetWidth,
                height: element.offsetHeight,
                center: element.offsetWidth / 2,
                middle: element.offsetHeight / 2
            };
        }

        /**
         * Set popup position
         */

    }, {
        key: 'setPlacement',
        value: function setPlacement() {
            var scrolling = arguments.length <= 0 || arguments[0] === undefined ? false : arguments[0];

            if (!this.state.active || this.state.closing) {
                return;
            }
            if (!this.popupRef || !this.popupRef.popupEl) {
                return;
            }
            var popupHTMLElement = this.popupRef.popupEl;

            // If target wasn't provided, then assuming that popup used as child of element, we can obtain target then
            var targetEl = this.props.target || _reactDom2.default.findDOMNode(this);
            if (!targetEl) {
                return;
            }

            // mark current position as tried
            this.positionsTried.push(this.state.position);

            var targetElementPosition = this.getTargetPosition(targetEl);
            var popupDimensions = this.getPopupDimensions(popupHTMLElement);

            if (scrolling && this.props.requestCloseWhenOffScreen) {
                this.requestCloseWhenOffScreen(targetElementPosition);
            }

            // need to know margins
            var computedStyle = window.getComputedStyle(popupHTMLElement);
            var margins = {
                top: parseFloat(computedStyle.marginTop),
                bottom: parseFloat(computedStyle.marginBottom),
                left: parseFloat(computedStyle.marginLeft),
                right: parseFloat(computedStyle.marginRight)
            };
            // assuming that all margins should be equal, using it because if popup will be autopositioned to opposite direction, then
            // getComputedStyle will not return correct margin, since it could be not-rerendered yet
            var margin = margins.bottom || margins.right || margins.left || margins.top || 0;
            // calculate popup position
            var finalPosition = this.calculatePopupPosition(this.state.position, targetElementPosition, popupDimensions, margin);
            // Recalculate position if needed
            var nextPosition = null;
            if (this.props.autoPosition && this.positionsTried.length <= _popupelement.POSITIONS.length) {
                nextPosition = this.autoPosition(finalPosition, popupDimensions);
                if (nextPosition) {
                    finalPosition = this.calculatePopupPosition(nextPosition, targetElementPosition, popupDimensions, margin);
                }
            }

            this.setState({
                position: nextPosition ? nextPosition : this.state.position, // eslint-disable-line
                positionStyleTop: finalPosition.top + 'px',
                positionStyleLeft: finalPosition.left + 'px'
            });

            // apply position to popup
            /*        popupHTMLElement.style.left = `${finalPosition.left}px`;
             popupHTMLElement.style.top = `${finalPosition.top}px`;
             popupHTMLElement.style.bottom = 'auto';
             popupHTMLElement.style.right = 'auto';
             popupHTMLElement.style.display = 'block';*/
        }

        /**
         * Attempt to auto-position popup
         */

    }, {
        key: 'autoPosition',
        value: function autoPosition(finalPosition, popupDimensions) {
            if (finalPosition.top < 0 || finalPosition.top + popupDimensions.height > window.innerHeight || finalPosition.left < 0 || finalPosition.left + popupDimensions.width > window.innerWidth) {
                // obtain next position
                var nextPosition = this.getNextPosition();
                // if every position tried set to lastResortPosition if given
                if (!nextPosition) {
                    // in case of prefer=opposite fill positionsTried array manually
                    this.positionsTried = [].concat(_toConsumableArray(_popupelement.POSITIONS));
                    if (this.props.lastResortPosition) {
                        nextPosition = this.props.lastResortPosition;
                    } else {
                        nextPosition = this.state.position;
                    }
                }
                return nextPosition;
            } else {
                // looks like we found a good position reset lastPositions list
                this.positionsTried = [];
            }
            return null;
        }

        /**
         * Return next popup position to try depending of current prefer style, or null if every position was tried
         */

    }, {
        key: 'getNextPosition',
        value: function getNextPosition() {
            if (this.positionsTried.length >= _popupelement.POSITIONS.length) {
                return null;
            }
            var currentPositionIndex = _popupelement.POSITIONS.indexOf(this.state.position);
            if (currentPositionIndex === -1) {
                return null;
            }

            switch (this.props.prefer) {
                case 'adjacent':
                default:
                    var nextPosition = null;
                    // We know now that at least one untried position should be available here
                    /* eslint-disable no-constant-condition */
                    while (true) {
                        // Reset index if we're off from array
                        if (currentPositionIndex + 1 > _popupelement.POSITIONS.length) {
                            currentPositionIndex = 0;
                        }
                        nextPosition = _popupelement.POSITIONS[currentPositionIndex];
                        if (this.positionsTried.indexOf(nextPosition) === -1) {
                            break;
                        }
                        currentPositionIndex++;
                    }
                    /* eslint-enable no-constant-condition */
                    return nextPosition;
                case 'opposite':
                    // just return opposite direction
                    switch (this.state.position) {
                        case 'left center':
                            return this.positionsTried.indexOf('right center') === -1 ? 'right center' : null;
                        case 'right center':
                            return this.positionsTried.indexOf('left center') === -1 ? 'left center' : null;
                        case 'top left':
                            return this.positionsTried.indexOf('bottom left') === -1 ? 'bottom left' : null;
                        case 'top center':
                            return this.positionsTried.indexOf('bottom center') === -1 ? 'bottom center' : null;
                        case 'top right':
                            return this.positionsTried.indexOf('bottom right') === -1 ? 'bottom right' : null;
                        case 'bottom left':
                            return this.positionsTried.indexOf('top left') === -1 ? 'top left' : null;
                        case 'bottom center':
                            return this.positionsTried.indexOf('top center') === -1 ? 'top center' : null;
                        case 'bottom right':
                            return this.positionsTried.indexOf('top right') === -1 ? 'top right' : null;
                        default:
                            return null;
                    }
            }
        }

        /**
         * Return true if element is off screen
         * @param targetPosition
         */

    }, {
        key: 'requestCloseWhenOffScreen',
        value: function requestCloseWhenOffScreen(targetPosition) {
            if (targetPosition.top < 0 || targetPosition.top > window.innerHeight || targetPosition.left < 0 || targetPosition.left > window.innerWidth) {
                this.props.onRequestClose();
            }
        }

        /**
         * Return popup position by taking account of elements boundaries and current this.state.position
         * @param position
         * @param targetPosition
         * @param popupDimensions
         * @param margin {number}
         */

    }, {
        key: 'calculatePopupPosition',
        value: function calculatePopupPosition(position, targetPosition, popupDimensions, margin) {
            var offset = this.props.offset;
            var distanceAway = this.props.distanceAway;

            switch (position) {
                case 'top left':
                    return {
                        left: targetPosition.left + offset,
                        top: targetPosition.top - popupDimensions.height - margin - distanceAway
                    };
                case 'top center':
                    return {
                        left: targetPosition.center - popupDimensions.center + offset,
                        top: targetPosition.top - popupDimensions.height - margin - distanceAway
                    };
                case 'top right':
                    return {
                        left: targetPosition.right - popupDimensions.width - offset,
                        top: targetPosition.top - popupDimensions.height - margin - distanceAway
                    };
                case 'left center':
                    return {
                        left: targetPosition.left - popupDimensions.width - margin - distanceAway,
                        top: targetPosition.middle - popupDimensions.middle + offset
                    };
                case 'right center':
                    // not needed here to take margins into account
                    return {
                        left: targetPosition.right + distanceAway,
                        top: targetPosition.middle - popupDimensions.middle + offset
                    };
                case 'bottom left':
                    return {
                        left: targetPosition.left + offset,
                        top: targetPosition.bottom + distanceAway
                    };
                case 'bottom center':
                    return {
                        left: targetPosition.center - popupDimensions.center + offset,
                        top: targetPosition.bottom + distanceAway
                    };
                case 'bottom right':
                    return {
                        left: targetPosition.right - popupDimensions.width - offset,
                        top: targetPosition.bottom + distanceAway
                    };
            }
        }
    }]);

    return Popup;
}(_react2.default.Component), _class.defaultProps = _extends({}, _popupelement2.default.defaultProps, {
    requestCloseWhenOffScreen: true,
    autoPosition: true,
    active: false,
    distanceAway: 0,
    offset: 0,
    initialAnimation: {
        scale: 0.5
    },
    enterAnimation: {
        scale: (0, _reactMotion.spring)(1, { stiffness: 500, damping: 30, precision: 0.1 })
    },
    leaveAnimation: {
        scale: (0, _reactMotion.spring)(0, { stiffness: 500, damping: 30, precision: 0.1 })
    },
    onRequestClose: function onRequestClose() {},
    preventElementClicks: true,
    prefer: 'adjacent',
    zIndex: 1000
}), _class.Components = {
    PopupElement: _popupelement2.default
}, _temp);
exports.default = Popup;
//# sourceMappingURL=popup.js.map