'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactAddonsShallowCompare = require('react-addons-shallow-compare');

var _reactAddonsShallowCompare2 = _interopRequireDefault(_reactAddonsShallowCompare);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _defaultProps = require('../../defaultProps');

var _defaultProps2 = _interopRequireDefault(_defaultProps);

var _icon = require('./icon');

var _icon2 = _interopRequireDefault(_icon);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * Rating
 */
var Rating = (_temp = _class = function (_React$Component) {
    _inherits(Rating, _React$Component);

    function Rating(props) {
        _classCallCheck(this, Rating);

        var _this = _possibleConstructorReturn(this, Object.getPrototypeOf(Rating).call(this, props));

        _this.onRatingIconClick = function (index) {
            var _this$props = _this.props;
            var onChange = _this$props.onChange;
            var value = _this$props.value;

            if (index !== value) {
                onChange(index);
            }
        };

        _this.onRatingIconMouseEnter = function (index) {
            _this.setState({ hovered: index });
        };

        _this.onRatingIconMouseLeave = function (index) {
            _this.setState({ hovered: 0 });
        };

        _this.state = {
            hovered: 0
        };
        return _this;
    }

    _createClass(Rating, [{
        key: 'shouldComponentUpdate',
        value: function shouldComponentUpdate(nextProps, nextState) {
            return (0, _reactAddonsShallowCompare2.default)(this, nextProps, nextState);
        }

        /**
         * Rating click handler
         * @param index
         */


        /**
         * Mouse enter hover handler
         * @param index
         */


        /**
         * Mouse leave hover handler
         * @param index
         */

    }, {
        key: 'renderIcons',
        value: function renderIcons() {
            var icons = [];
            var _props = this.props;
            var max = _props.max;
            var value = _props.value;
            var hovered = this.state.hovered;

            // Indexes are from 1

            for (var i = 1; i <= max; i++) {
                icons.push(_react2.default.createElement(_icon2.default, { key: i,
                    index: i,
                    active: i <= value,
                    selected: i <= hovered,
                    onClick: this.onRatingIconClick,
                    onMouseEnter: this.onRatingIconMouseEnter,
                    onMouseLeave: this.onRatingIconMouseLeave
                }));
            }
            return icons;
        }
    }, {
        key: 'render',
        value: function render() {
            /* eslint-disable no-use-before-define */
            var _props2 = this.props;
            var component = _props2.component;
            var defaultClasses = _props2.defaultClasses;
            var type = _props2.type;
            var max = _props2.max;
            var size = _props2.size;
            var value = _props2.value;
            var onChange = _props2.onChange;

            var other = _objectWithoutProperties(_props2, ['component', 'defaultClasses', 'type', 'max', 'size', 'value', 'onChange']);
            /* eslint-enable no-use-before-define */

            other.className = (0, _classnames2.default)(this.props.className, this.getClasses());
            var Component = component;
            return _react2.default.createElement(
                Component,
                other,
                this.renderIcons()
            );
        }
    }, {
        key: 'getClasses',
        value: function getClasses() {
            var _ref;

            return _ref = {
                ui: this.props.defaultClasses
            }, _defineProperty(_ref, this.props.size, !!this.props.size), _defineProperty(_ref, 'star', this.props.type === 'star'), _defineProperty(_ref, 'heart', this.props.type === 'heart'), _defineProperty(_ref, 'rating', this.props.defaultClasses), _ref;
        }
    }]);

    return Rating;
}(_react2.default.Component), _class.defaultProps = _extends({}, _defaultProps2.default.defaultProps, {
    type: 'default',
    value: 0,
    max: 5
}), _temp);
exports.default = Rating;
//# sourceMappingURL=rating.js.map