'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactAddonsShallowCompare = require('react-addons-shallow-compare');

var _reactAddonsShallowCompare2 = _interopRequireDefault(_reactAddonsShallowCompare);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _content = require('./../../elements/simple/content');

var _content2 = _interopRequireDefault(_content);

var _defaultProps = require('../../defaultProps');

var _defaultProps2 = _interopRequireDefault(_defaultProps);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Results = (_temp = _class = function (_React$Component) {
    _inherits(Results, _React$Component);

    function Results() {
        _classCallCheck(this, Results);

        return _possibleConstructorReturn(this, Object.getPrototypeOf(Results).apply(this, arguments));
    }

    _createClass(Results, [{
        key: 'shouldComponentUpdate',

        /* eslint-enable */

        value: function shouldComponentUpdate(nextProps, nextState) {
            return (0, _reactAddonsShallowCompare2.default)(this, nextProps, nextState);
        }

        /* eslint-disable */

    }, {
        key: 'onClick',
        value: function onClick(child, e) {
            this.props.onSearchClick(e, child);
        }
    }, {
        key: 'renderChildren',
        value: function renderChildren() {
            if (this.props.results.length === 0) {
                return this.renderEmpty();
            } else if (Array.isArray(this.props.results)) {
                return this.renderArray();
            } else if (_typeof(this.props.results) === 'object') {
                return this.renderObject();
            } else {
                return false;
            }
        }
    }, {
        key: 'renderArray',
        value: function renderArray(results) {
            var _this2 = this;

            results = results || this.props.results;

            return results.map(function (child, key) {
                var description = null;
                var title = (typeof child === 'undefined' ? 'undefined' : _typeof(child)) === 'object' ? child.title : child;

                // use title and description
                if ((typeof child === 'undefined' ? 'undefined' : _typeof(child)) === 'object' && child.description) {
                    description = _react2.default.createElement(
                        'div',
                        { className: 'description' },
                        child.description
                    );
                }

                return _react2.default.createElement(
                    'a',
                    { className: 'result',
                        key: key,
                        onMouseDown: _this2.onClick.bind(_this2, title)
                    },
                    _react2.default.createElement(
                        Results.Components.Content,
                        null,
                        _react2.default.createElement(
                            'div',
                            { className: 'title' },
                            title
                        ),
                        description
                    )
                );
            });
        }
    }, {
        key: 'renderObject',
        value: function renderObject() {
            var _this3 = this;

            var children = [];

            Object.keys(this.props.results).map(function (child, key) {
                children.push(_react2.default.createElement(
                    'div',
                    { className: 'category', key: key },
                    _react2.default.createElement(
                        'div',
                        { className: 'name' },
                        child
                    ),
                    _this3.renderArray(_this3.props.results[child])
                ));
            });

            return children;
        }
    }, {
        key: 'renderEmpty',
        value: function renderEmpty() {
            return _react2.default.createElement(
                'div',
                { className: 'message empty', key: 'empty' },
                _react2.default.createElement(
                    'div',
                    { className: 'header' },
                    this.props.emptyHeader
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'description' },
                    this.props.emptyMessage
                )
            );
        }
    }, {
        key: 'render',
        value: function render() {
            /* eslint-disable no-use-before-define */
            var _props = this.props;
            var children = _props.children;
            var className = _props.className;
            var component = _props.component;
            var defaultClasses = _props.defaultClasses;
            var emptyHeader = _props.emptyHeader;
            var emptyMessage = _props.emptyMessage;
            var onSearchClick = _props.onSearchClick;
            var results = _props.results;
            var search = _props.search;
            var style = _props.style;

            var other = _objectWithoutProperties(_props, ['children', 'className', 'component', 'defaultClasses', 'emptyHeader', 'emptyMessage', 'onSearchClick', 'results', 'search', 'style']);
            /* eslint-enable no-use-before-define */

            other.className = (0, _classnames2.default)(this.props.className, this.getClasses());
            other.style = this.props.style;

            return _react2.default.createElement(this.props.component, other, this.renderChildren());
        }
    }, {
        key: 'getClasses',
        value: function getClasses() {
            return {
                results: this.props.defaultClasses,

                transition: this.props.defaultClasses,
                visible: this.props.defaultClasses
            };
        }
    }]);

    return Results;
}(_react2.default.Component), _class.defaultProps = _extends({}, _defaultProps2.default.defaultProps, {
    emptyHeader: 'No Results',
    emptyMessage: 'Your search returned no results'
}), _class.Components = {
    Content: _content2.default
}, _temp);
exports.default = Results;
//# sourceMappingURL=results.js.map